/*
 * Decompiled with CFR 0.152.
 */
package de.fjobilabs.twitter.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.fjobilabs.twitter.Coordinates;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CoordinatesDTO
implements Coordinates {
    private float[] coordinates;
    private String type;

    public CoordinatesDTO(Coordinates coordinates) {
        this.coordinates = new float[]{coordinates.getLatitude(), coordinates.getLongitude()};
        this.type = coordinates.getType();
    }

    public float[] getCoordinates() {
        return this.coordinates;
    }

    @JsonIgnore
    public float getLongitude() {
        if (this.coordinates.length != 2) {
            throw new IllegalStateException("coordinates array not valid! coordinates.length must be 2");
        }
        return this.coordinates[0];
    }

    @JsonIgnore
    public float getLatitude() {
        if (this.coordinates.length != 2) {
            throw new IllegalStateException("coordinates array not valid! coordinates.length must be 2");
        }
        return this.coordinates[1];
    }

    public String getType() {
        return this.type;
    }
}

