/*
 * Decompiled with CFR 0.152.
 */
package de.fjobilabs.twitter.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fjobilabs.twitter.Entity;

public abstract class AbstractEntityDTO
implements Entity {
    private int[] indices;
    private String text;

    AbstractEntityDTO(int[] indices, String text) {
        if (indices.length != 2) {
            throw new IllegalArgumentException("indices.length must be 2");
        }
        this.indices = new int[]{indices[0], indices[1]};
        this.text = text;
    }

    protected AbstractEntityDTO(Entity entity) {
        this.indices = new int[]{entity.getStartIndex(), entity.getEndIndex()};
        this.text = entity.getText();
    }

    public int[] getIndices() {
        return this.indices;
    }

    @JsonIgnore
    public int getStartIndex() {
        return this.indices[0];
    }

    @JsonIgnore
    public int getEndIndex() {
        return this.indices[1];
    }

    public String getText() {
        return this.text;
    }
}

