/*
 * Decompiled with CFR 0.152.
 */
package de.fjobilabs.botometer.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.fjobilabs.botometer.AccountData;
import de.fjobilabs.twitter.Tweet;
import de.fjobilabs.twitter.User;
import de.fjobilabs.twitter.dto.TweetDTO;
import de.fjobilabs.twitter.dto.UserDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AccountDataDTO
implements AccountData {
    private UserDTO user;
    private List<TweetDTO> timeline;
    private List<TweetDTO> mentions;

    AccountDataDTO() {
    }

    public AccountDataDTO(UserDTO user, List<TweetDTO> timeline, List<TweetDTO> mentions) {
        Objects.requireNonNull(user, "user must not be null");
        Objects.requireNonNull(timeline, "timeline must not be null");
        Objects.requireNonNull(mentions, "mentions must not be null");
        this.user = user;
        this.timeline = Collections.unmodifiableList(new ArrayList<TweetDTO>(timeline));
        this.mentions = Collections.unmodifiableList(new ArrayList<TweetDTO>(mentions));
    }

    public AccountDataDTO(AccountData accountData) {
        this.user = new UserDTO(accountData.getUser());
        this.timeline = accountData.getTimeline().stream().map(TweetDTO::new).collect(Collectors.toList());
        this.mentions = accountData.getMentions().stream().map(TweetDTO::new).collect(Collectors.toList());
    }

    public User getUser() {
        return this.user;
    }

    public List<? extends Tweet> getTimeline() {
        return this.timeline;
    }

    public List<? extends Tweet> getMentions() {
        return this.mentions;
    }
}

