/*
 * Decompiled with CFR 0.152.
 */
package de.fjobilabs.botometer.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.fjobilabs.botometer.BotometerException;
import de.fjobilabs.botometer.ClassificationResult;
import de.fjobilabs.botometer.api.ApiError;
import de.fjobilabs.botometer.api.BotometerApiException;
import de.fjobilabs.botometer.client.AbstractBotometerClient;
import de.fjobilabs.botometer.client.BotometerClientException;
import de.fjobilabs.botometer.dto.ClassificationResultDTO;
import java.io.IOException;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBotometerClient
extends AbstractBotometerClient {
    private static final String BOTOMETER_CHECK_ACCOUNT_URL = "https://osome-botometer.p.rapidapi.com/2/check_account";
    private static final MediaType JSON_MEDIA_TYPE = MediaType.get((String)"application/json; charset=utf-8");
    private static final Logger logger = LoggerFactory.getLogger(DefaultBotometerClient.class);
    private String apiKey;
    private OkHttpClient httpClient;

    public DefaultBotometerClient(String apiKey) {
        Objects.requireNonNull(apiKey, "apikey must not be null");
        this.apiKey = apiKey;
        this.httpClient = new OkHttpClient();
    }

    public ClassificationResult checkAccount(byte[] accountDataJson) throws BotometerException, IOException {
        RequestBody body = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (byte[])accountDataJson);
        Request request = new Request.Builder().url(BOTOMETER_CHECK_ACCOUNT_URL).header("X-RapidAPI-Key", this.apiKey).post(body).build();
        Throwable throwable = null;
        try (Response response = this.httpClient.newCall(request).execute();){
            if (response.isSuccessful()) {
                ClassificationResult classificationResult = this.readClassifcationResult(response.body());
                return classificationResult;
            }
            try {
                throw this.createApiErrorException(response);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private BotometerApiException createApiErrorException(Response response) {
        int statusCode = response.code();
        if (response.body().contentLength() > 0L) {
            ApiError apiError;
            try {
                apiError = (ApiError)this.objectMapper.readValue(response.body().byteStream(), ApiError.class);
            }
            catch (IOException e) {
                logger.warn("Failed to read error response body");
                logger.debug("Exception in error response deserialisation:", (Throwable)e);
                return BotometerApiException.create((int)statusCode);
            }
            return BotometerApiException.create((int)statusCode, (ApiError)apiError);
        }
        return BotometerApiException.create((int)statusCode);
    }

    private ClassificationResult readClassifcationResult(ResponseBody body) throws IOException {
        try {
            return (ClassificationResult)this.objectMapper.readValue(body.byteStream(), ClassificationResultDTO.class);
        }
        catch (JsonParseException e) {
            throw new BotometerClientException("Failed to parse response body", e);
        }
        catch (JsonMappingException e) {
            throw new BotometerClientException("Failed to read response body", e);
        }
        catch (IOException e) {
            throw new IOException("IOException while reading response body", e);
        }
    }
}

