/*
 * Decompiled with CFR 0.152.
 */
package de.fjobilabs.botometer.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.fjobilabs.botometer.AccountData;
import de.fjobilabs.botometer.BotometerException;
import de.fjobilabs.botometer.ClassificationResult;
import de.fjobilabs.botometer.api.BotometerClient;
import de.fjobilabs.botometer.api.BotometerOperations;
import de.fjobilabs.botometer.api.BotometerRawOperations;
import de.fjobilabs.botometer.client.ObjectMapperFactory;
import de.fjobilabs.botometer.dto.AccountDataDTO;
import de.fjobilabs.twitter.Tweet;
import de.fjobilabs.twitter.User;
import de.fjobilabs.twitter.dto.TweetDTO;
import de.fjobilabs.twitter.dto.UserDTO;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractBotometerClient
implements BotometerClient,
BotometerRawOperations,
BotometerOperations {
    protected ObjectMapper objectMapper = ObjectMapperFactory.getInstance().create();

    public BotometerOperations getBotometerOperations() {
        return this;
    }

    public BotometerRawOperations getRawOperations() {
        return this;
    }

    public ClassificationResult checkAccount(AccountData accountData) throws BotometerException, IOException {
        return this.checkAccountDTO(new AccountDataDTO(accountData));
    }

    public ClassificationResult checkAccount(User user, List<Tweet> timeline, List<Tweet> mentions) throws BotometerException, IOException {
        List<TweetDTO> timelineDtos = timeline.stream().map(TweetDTO::new).collect(Collectors.toList());
        List<TweetDTO> mentionsDtos = mentions.stream().map(TweetDTO::new).collect(Collectors.toList());
        return this.checkAccountDTO(new AccountDataDTO(new UserDTO(user), timelineDtos, mentionsDtos));
    }

    private ClassificationResult checkAccountDTO(AccountDataDTO accountData) throws BotometerException, IOException {
        try {
            return this.checkAccount(this.objectMapper.writeValueAsBytes((Object)accountData));
        }
        catch (JsonProcessingException e) {
            throw new BotometerException("Failed to serialize account data to JSON", (Throwable)e);
        }
    }

    public ClassificationResult checkAccount(String accountDataJson) throws BotometerException, IOException {
        return this.checkAccount(accountDataJson.getBytes());
    }

    public ClassificationResult checkAccount(String userJson, String timelineJson, String mentionsJson) throws BotometerException, IOException {
        return this.checkAccount(userJson.getBytes(), timelineJson.getBytes(), mentionsJson.getBytes());
    }

    public ClassificationResult checkAccount(byte[] userJson, byte[] timelineJson, byte[] mentionsJson) throws BotometerException, IOException {
        return this.checkAccount(this.createAccountDataJson(userJson, timelineJson, mentionsJson));
    }

    private byte[] createAccountDataJson(byte[] userJson, byte[] timelineJson, byte[] mentionsJson) {
        ArrayNode mentionsNode;
        ArrayNode timelineNode;
        JsonNode userNode;
        try {
            userNode = this.objectMapper.readTree(userJson);
        }
        catch (JsonParseException e) {
            throw new BotometerException("Invalid userJson", (Throwable)e);
        }
        catch (IOException e) {
            throw new BotometerException("Unexpected IOException while reading userJson", (Throwable)e);
        }
        try {
            timelineNode = (ArrayNode)this.objectMapper.readValue(timelineJson, ArrayNode.class);
        }
        catch (JsonParseException e) {
            throw new BotometerException("Invalid timelineJson", (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new BotometerException("Invalid timelineJson. Cannot map to array", (Throwable)e);
        }
        catch (IOException e) {
            throw new BotometerException("Unexpected IOException while reading timelineJson", (Throwable)e);
        }
        try {
            mentionsNode = (ArrayNode)this.objectMapper.readValue(mentionsJson, ArrayNode.class);
        }
        catch (JsonParseException e) {
            throw new BotometerException("Invalid mentionsJson", (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new BotometerException("Invalid mentionsJson. Cannot map to array", (Throwable)e);
        }
        catch (IOException e) {
            throw new BotometerException("Unexpected IOException while reading mentionsJson", (Throwable)e);
        }
        ObjectNode accountDataNode = this.objectMapper.createObjectNode();
        accountDataNode.set("user", userNode);
        accountDataNode.set("timeline", (JsonNode)timelineNode);
        accountDataNode.set("mentions", (JsonNode)mentionsNode);
        try {
            return this.objectMapper.writeValueAsBytes((Object)accountDataNode);
        }
        catch (JsonProcessingException e) {
            throw new BotometerException("Unexpected Exception while composing accoutn datat JSON", (Throwable)e);
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

