/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.treeg.ast;

import de.firemage.autograder.treeg.TreePrinter;
import de.firemage.autograder.treeg.ast.RegExNode;

public record Group(RegExNode root, String name, Type type, String flags) implements RegExNode
{
    @Override
    public String toRegEx() {
        String prefix = switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.CAPTURING -> {
                if (this.name != null) {
                    yield "?<" + this.name + ">";
                }
                yield "";
            }
            case Type.NON_CAPTURING -> "?" + this.flags + ":";
            case Type.INDEPENDENT_NON_CAPTURING -> "?>";
        };
        return "(" + prefix + this.root.toRegEx() + ")";
    }

    @Override
    public void toTree(TreePrinter printer) {
        if (this.name != null) {
            printer.addLine("Named Group ('" + this.name + "')");
        } else {
            printer.addLine("Group");
        }
        printer.indent();
        this.root.toTree(printer);
        printer.unindent();
    }

    public static enum Type {
        CAPTURING,
        NON_CAPTURING,
        INDEPENDENT_NON_CAPTURING;

    }
}

