/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.treeg.ast;

import de.firemage.autograder.treeg.TreePrinter;
import de.firemage.autograder.treeg.ast.RegExNode;

public record BoundaryMatcher(Type type) implements RegExNode
{
    @Override
    public String toRegEx() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.LINE_START -> "^";
            case Type.LINE_END -> "$";
            case Type.WORD_BOUNDARY -> "\\b";
            case Type.NON_WORD_BOUNDARY -> "\\B";
            case Type.INPUT_START -> "\\A";
            case Type.MATCH_END -> "\\G";
            case Type.INPUT_END_BEFORE_TERMINATOR -> "\\Z";
            case Type.INPUT_END -> "\\z";
            case Type.LINEBREAK -> "\\R";
        };
    }

    @Override
    public void toTree(TreePrinter printer) {
        printer.addLine(this.type.toString());
    }

    public static enum Type {
        LINE_START,
        LINE_END,
        WORD_BOUNDARY,
        NON_WORD_BOUNDARY,
        INPUT_START,
        MATCH_END,
        INPUT_END_BEFORE_TERMINATOR,
        INPUT_END,
        LINEBREAK;

    }
}

