/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import spoon.JLSViolation;
import spoon.processing.FactoryAccessor;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtRecordComponent;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.CtExtendedModifier;
import spoon.support.reflect.declaration.CtNamedElementImpl;

public class CtRecordComponentImpl
extends CtNamedElementImpl
implements CtRecordComponent {
    private static final Set<String> forbiddenNames = CtRecordComponentImpl.createForbiddenNames();
    @MetamodelPropertyField(role={CtRole.TYPE})
    private CtTypeReference<Object> type;
    @MetamodelPropertyField(role={CtRole.IS_SHADOW})
    boolean isShadow;

    public CtMethod<?> toMethod() {
        CtMethod method = this.getFactory().createMethod();
        method.setSimpleName(this.getSimpleName());
        method.setType(this.getType().clone());
        method.setExtendedModifiers(Collections.singleton(new CtExtendedModifier(ModifierKind.PUBLIC, true)));
        method.setImplicit(true);
        method.setBody((CtStatement)this.getFactory().createCodeSnippetStatement("return " + this.getSimpleName()));
        return method;
    }

    public CtField<?> toField() {
        CtField field = this.getFactory().createField();
        field.setSimpleName(this.getSimpleName());
        field.setType(this.getType());
        HashSet<CtExtendedModifier> modifiers = new HashSet<CtExtendedModifier>();
        modifiers.add(new CtExtendedModifier(ModifierKind.PRIVATE, true));
        modifiers.add(new CtExtendedModifier(ModifierKind.FINAL, true));
        field.setExtendedModifiers(modifiers);
        field.setImplicit(true);
        return field;
    }

    public boolean isImplicit() {
        return true;
    }

    public CtTypeReference<Object> getType() {
        return this.type;
    }

    public <C extends CtTypedElement> C setType(CtTypeReference type) {
        if (type != null) {
            type.setParent((CtElement)this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.TYPE, (CtElement)type, this.type);
        this.type = type;
        return (C)((Object)this);
    }

    public void accept(CtVisitor visitor) {
        visitor.visitCtRecordComponent((CtRecordComponent)this);
    }

    public <T extends CtNamedElement> T setSimpleName(String simpleName) {
        this.checkName(simpleName);
        return (T)super.setSimpleName(simpleName);
    }

    private void checkName(String simpleName) {
        if (forbiddenNames.contains(simpleName)) {
            JLSViolation.throwIfSyntaxErrorsAreNotIgnored((FactoryAccessor)this, (String)("The name '" + simpleName + "' is not allowed as record component name."));
        }
    }

    private static Set<String> createForbiddenNames() {
        return Set.of("clone", "finalize", "getClass", "notify", "notifyAll", "equals", "hashCode", "toString", "wait");
    }

    public CtRecordComponent clone() {
        return (CtRecordComponent)super.clone();
    }

    public boolean isShadow() {
        return this.isShadow;
    }

    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IS_SHADOW, (Object)isShadow, (Object)this.isShadow);
        this.isShadow = isShadow;
        return (E)((Object)this);
    }
}

