/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.structure;

import de.firemage.autograder.core.integrated.structure.StructuralEqualsVisitor;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;

public final class StructuralHashCodeVisitor
extends CtScanner {
    private final HashCodeBuilder builder = new HashCodeBuilder();

    private StructuralHashCodeVisitor() {
    }

    public static int computeHashCode(CtElement element) {
        StructuralHashCodeVisitor visitor = new StructuralHashCodeVisitor();
        visitor.scan(element);
        return visitor.getHashCode();
    }

    public void enter(CtElement ctElement) {
        if (ctElement instanceof CtTypeReference) {
            CtTypeReference ctTypeReference = (CtTypeReference)ctElement;
            this.builder.append((Object)ctTypeReference.getSimpleName());
        }
        this.builder.append(ctElement.getClass().getSimpleName().hashCode());
    }

    public void scan(CtRole ctRole, CtElement element) {
        if (StructuralEqualsVisitor.shouldSkip(ctRole, element)) {
            return;
        }
        this.builder.append((Object)ctRole);
        super.scan(ctRole, element);
    }

    public int getHashCode() {
        return this.builder.toHashCode();
    }
}

