/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.structure;

import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.structure.StructuralHashCodeVisitor;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtTextBlock;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.visitor.equals.EqualsVisitor;

public final class StructuralEqualsVisitor
extends EqualsVisitor {
    private static final boolean IS_IN_DEBUG_MODE = SpoonUtil.isInJunitTest();
    private static final Set<CtRole> ALLOWED_MISMATCHING_ROLES = Set.of(CtRole.COMMENT, CtRole.COMMENT_CONTENT, CtRole.COMMENT_TAG, CtRole.COMMENT_TYPE);
    private final Set<Difference> differences = new LinkedHashSet<Difference>();

    public static boolean equals(CtElement left, CtElement right) {
        return new StructuralEqualsVisitor().checkEquals(left, right);
    }

    public boolean checkEquals(CtElement left, CtElement right) {
        if (IS_IN_DEBUG_MODE) {
            boolean result = super.checkEquals(left, right);
            int leftHashCode = StructuralHashCodeVisitor.computeHashCode(left);
            int rightHashCode = StructuralHashCodeVisitor.computeHashCode(right);
            if (result && leftHashCode != rightHashCode) {
                throw new IllegalStateException("StructuralHashCode is wrong for the equal objects: %s (hashCode=%d), %s (hashCode=%d)".formatted(left, leftHashCode, right, rightHashCode));
            }
            return result;
        }
        return super.checkEquals(left, right);
    }

    private static <T> boolean isConstantExpressionOr(CtExpression<T> e, final Predicate<? super CtExpression<?>> isAllowedExpression) {
        var visitor = new CtScanner(){
            private boolean isConstant = false;
            private boolean isDone = false;

            protected void exit(CtElement ctElement) {
                CtInvocation ctInvocation;
                CtExpression expression;
                block8: {
                    block7: {
                        if (!(ctElement instanceof CtExpression)) break block7;
                        expression = (CtExpression)ctElement;
                        if (!this.isDone) break block8;
                    }
                    return;
                }
                if (StructuralEqualsVisitor.isInstanceOfAny(expression, CtBinaryOperator.class, UnaryOperator.class, CtTextBlock.class, CtConditional.class, CtTypeAccess.class)) {
                    this.isConstant = true;
                    return;
                }
                if (expression instanceof CtInvocation && (ctInvocation = (CtInvocation)expression).getExecutable().isStatic()) {
                    this.isConstant = true;
                    return;
                }
                if (SpoonUtil.resolveConstant(expression) instanceof CtLiteral || isAllowedExpression.test(expression)) {
                    this.isConstant = true;
                } else {
                    this.isConstant = false;
                    this.isDone = true;
                }
            }
        };
        e.accept((CtVisitor)visitor);
        return visitor.isConstant;
    }

    private static boolean isRefactorable(Object element) {
        if (!(element instanceof CtElement)) {
            return false;
        }
        if (element instanceof CtExpression) {
            CtExpression ctExpression = (CtExpression)element;
            return StructuralEqualsVisitor.isConstantExpressionOr(ctExpression, e -> {
                if (e instanceof CtVariableRead) {
                    CtParameter ctParameter;
                    CtVariableRead ctVariableRead = (CtVariableRead)e;
                    CtVariable<?> ctVariable = SpoonUtil.getVariableDeclaration(ctVariableRead.getVariable());
                    return ctVariable instanceof CtParameter && SpoonUtil.isEffectivelyFinal(ctParameter = (CtParameter)ctVariable);
                }
                return false;
            });
        }
        return false;
    }

    private static boolean isInstanceOfAny(Object object, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldSkip(CtRole role, Object element) {
        if (role == null) {
            return false;
        }
        if (ALLOWED_MISMATCHING_ROLES.contains(role)) {
            return true;
        }
        if (role == CtRole.NAME && StructuralEqualsVisitor.isInstanceOfAny(element, CtLocalVariable.class, CtField.class, CtParameter.class)) {
            return true;
        }
        return (role == CtRole.LEFT_OPERAND || role == CtRole.RIGHT_OPERAND) && StructuralEqualsVisitor.isRefactorable(element);
    }

    protected boolean fail(CtRole role, Object element, Object other) {
        this.differences.add(new Difference(role, element, other));
        if (StructuralEqualsVisitor.shouldSkip(role, element)) {
            return false;
        }
        this.isNotEqual = true;
        this.notEqualRole = role;
        this.notEqualElement = element;
        this.notEqualOther = other;
        return true;
    }

    public Set<Difference> differences() {
        return new LinkedHashSet<Difference>(this.differences);
    }

    public record Difference(CtRole role, Object left, Object right) {
    }
}

