/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.evaluator.fold;

import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.evaluator.Evaluator;
import de.firemage.autograder.core.integrated.evaluator.OperatorHelper;
import de.firemage.autograder.core.integrated.evaluator.fold.Fold;
import de.firemage.autograder.core.integrated.evaluator.fold.FoldUtils;
import de.firemage.autograder.core.integrated.evaluator.fold.PromoteOperands;
import spoon.SpoonException;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.eval.PartialEvaluator;
import spoon.reflect.reference.CtTypeReference;

public final class EvaluateLiteralOperations
implements Fold {
    private final PartialEvaluator evaluator = new Evaluator(PromoteOperands.create());

    private EvaluateLiteralOperations() {
    }

    public static Fold create() {
        return new EvaluateLiteralOperations();
    }

    private boolean isFloatingType(CtTypeReference<?> type) {
        if (type == null) {
            return false;
        }
        return type.equals((Object)type.getFactory().Type().doublePrimitiveType()) || type.equals((Object)type.getFactory().Type().floatPrimitiveType()) || type.equals((Object)type.getFactory().Type().doubleType()) || type.equals((Object)type.getFactory().Type().floatType());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> CtExpression<T> foldCtBinaryOperator(CtBinaryOperator<T> ctBinaryOperator) {
        Object object;
        CtLiteral leftLiteral;
        CtExpression ctExpression;
        block37: {
            block36: {
                CtBinaryOperator promotedOperator = (CtBinaryOperator)this.evaluator.evaluate(ctBinaryOperator);
                ctExpression = promotedOperator.getLeftHandOperand();
                if (!(ctExpression instanceof CtLiteral)) break block36;
                leftLiteral = (CtLiteral)ctExpression;
                ctExpression = promotedOperator.getRightHandOperand();
                if (ctExpression instanceof CtLiteral) break block37;
            }
            return ctBinaryOperator;
        }
        CtLiteral rightLiteral = (CtLiteral)ctExpression;
        Object leftObject = leftLiteral.getValue();
        Object rightObject = rightLiteral.getValue();
        CtTypeReference<?> operatorType = SpoonUtil.getExpressionType(ctBinaryOperator);
        switch (ctBinaryOperator.getKind()) {
            case AND: {
                Object object2;
                object = object2 = Boolean.valueOf((Boolean)leftObject != false && (Boolean)rightObject != false);
                break;
            }
            case OR: {
                Object object2;
                object = object2 = Boolean.valueOf((Boolean)leftObject != false || (Boolean)rightObject != false);
                break;
            }
            case EQ: {
                Object object2;
                if (leftObject == null) {
                    object = object2 = Boolean.valueOf(leftObject == rightObject);
                    break;
                }
                object = object2 = Boolean.valueOf(leftObject.equals(rightObject));
                break;
            }
            case NE: {
                Object object2;
                if (leftObject == null) {
                    object = object2 = Boolean.valueOf(leftObject != rightObject);
                    break;
                }
                object = object2 = Boolean.valueOf(!leftObject.equals(rightObject));
                break;
            }
            case GE: {
                Object object2;
                object = object2 = Boolean.valueOf(((Number)leftObject).doubleValue() >= ((Number)rightObject).doubleValue());
                break;
            }
            case LE: {
                Object object2;
                object = object2 = Boolean.valueOf(((Number)leftObject).doubleValue() <= ((Number)rightObject).doubleValue());
                break;
            }
            case GT: {
                Object object2;
                object = object2 = Boolean.valueOf(((Number)leftObject).doubleValue() > ((Number)rightObject).doubleValue());
                break;
            }
            case LT: {
                Object object2;
                object = object2 = Boolean.valueOf(((Number)leftObject).doubleValue() < ((Number)rightObject).doubleValue());
                break;
            }
            case MINUS: {
                Object object2;
                object = object2 = FoldUtils.convert(operatorType, ((Number)leftObject).doubleValue() - ((Number)rightObject).doubleValue());
                break;
            }
            case MUL: {
                Object object2;
                object = object2 = FoldUtils.convert(operatorType, ((Number)leftObject).doubleValue() * ((Number)rightObject).doubleValue());
                break;
            }
            case DIV: {
                Object object2;
                try {
                    if (this.isFloatingType(operatorType)) {
                        object = object2 = FoldUtils.convert(operatorType, ((Number)leftObject).doubleValue() / ((Number)rightObject).doubleValue());
                        break;
                    }
                    object = object2 = FoldUtils.convert(operatorType, ((Number)leftObject).longValue() / ((Number)rightObject).longValue());
                    break;
                }
                catch (ArithmeticException exception) {
                    throw new SpoonException(String.format("Expression '%s' evaluates to '%s %s %s' which can not be evaluated", ctBinaryOperator, leftObject, OperatorHelper.getOperatorText(ctBinaryOperator.getKind()), rightObject), (Throwable)exception);
                }
            }
            case PLUS: {
                Object object2;
                if (leftObject instanceof String || rightObject instanceof String) {
                    object = object2 = "" + leftObject + rightObject;
                    break;
                }
                object = object2 = FoldUtils.convert(operatorType, ((Number)leftObject).doubleValue() + ((Number)rightObject).doubleValue());
                break;
            }
            case MOD: {
                Object object2;
                object = object2 = FoldUtils.convert(operatorType, ((Number)leftObject).doubleValue() % ((Number)rightObject).doubleValue());
                break;
            }
            case BITAND: {
                Object object2;
                if (leftObject instanceof Boolean) {
                    object = object2 = Boolean.valueOf((Boolean)leftObject != false && (Boolean)rightObject != false);
                    break;
                }
                object = object2 = FoldUtils.convert(operatorType, ((Number)leftObject).longValue() & ((Number)rightObject).longValue());
                break;
            }
            case BITOR: {
                Object object2;
                if (leftObject instanceof Boolean) {
                    object = object2 = Boolean.valueOf((Boolean)leftObject != false || (Boolean)rightObject != false);
                    break;
                }
                object = object2 = FoldUtils.convert(operatorType, ((Number)leftObject).longValue() | ((Number)rightObject).longValue());
                break;
            }
            case BITXOR: {
                Object object2;
                if (leftObject instanceof Boolean) {
                    object = object2 = Boolean.valueOf((Boolean)leftObject ^ (Boolean)rightObject);
                    break;
                }
                object = object2 = FoldUtils.convert(operatorType, ((Number)leftObject).longValue() ^ ((Number)rightObject).longValue());
                break;
            }
            case SL: {
                Object object2;
                long rightObjectValue = ((Number)rightObject).longValue();
                if (leftObject instanceof Long) {
                    object = object2 = Long.valueOf((Long)leftObject << (int)rightObjectValue);
                    break;
                }
                object = object2 = Integer.valueOf(((Number)leftObject).intValue() << (int)rightObjectValue);
                break;
            }
            case SR: {
                Object object2;
                long rightObjectValue = ((Number)rightObject).longValue();
                if (leftObject instanceof Long) {
                    object = object2 = Long.valueOf((Long)leftObject >> (int)rightObjectValue);
                    break;
                }
                object = object2 = Integer.valueOf(((Number)leftObject).intValue() >> (int)rightObjectValue);
                break;
            }
            case USR: {
                Object object2;
                long rightObjectValue = ((Number)rightObject).longValue();
                if (leftObject instanceof Long) {
                    object = object2 = Long.valueOf((Long)leftObject >>> (int)rightObjectValue);
                    break;
                }
                object = object2 = Integer.valueOf(((Number)leftObject).intValue() >>> (int)rightObjectValue);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Operator '%s'".formatted(ctBinaryOperator.getKind()));
            }
        }
        Object value = object;
        return ctBinaryOperator.getFactory().createLiteral(value);
    }

    @Override
    public <T> CtExpression<T> foldCtUnaryOperator(CtUnaryOperator<T> ctUnaryOperator) {
        CtUnaryOperator promotedOperator = (CtUnaryOperator)this.evaluator.evaluate(ctUnaryOperator);
        CtExpression operand = promotedOperator.getOperand();
        if (!(operand instanceof CtLiteral)) {
            return ctUnaryOperator;
        }
        CtLiteral literal = (CtLiteral)operand;
        CtTypeReference<?> operatorType = SpoonUtil.getExpressionType(promotedOperator);
        Object literalValue = literal.getValue();
        Boolean value = switch (promotedOperator.getKind()) {
            case UnaryOperatorKind.NOT -> (Boolean)literalValue == false;
            case UnaryOperatorKind.NEG -> {
                if (this.isFloatingType(operatorType)) {
                    yield FoldUtils.convert(operatorType, -1.0 * ((Number)literalValue).doubleValue());
                }
                yield FoldUtils.convert(operatorType, -1L * ((Number)literalValue).longValue());
            }
            case UnaryOperatorKind.POS -> {
                if (this.isFloatingType(literal.getType())) {
                    yield FoldUtils.convert(operatorType, ((Number)literalValue).doubleValue());
                }
                yield FoldUtils.convert(operatorType, ((Number)literalValue).longValue());
            }
            case UnaryOperatorKind.COMPL -> FoldUtils.convert(operatorType, ((Number)literalValue).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            default -> throw new UnsupportedOperationException("Unsupported Operator '%s'".formatted(ctUnaryOperator.getKind()));
        };
        return ctUnaryOperator.getFactory().createLiteral((Object)value);
    }
}

