/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.evaluator;

import de.firemage.autograder.core.integrated.evaluator.fold.ChainedFold;
import de.firemage.autograder.core.integrated.evaluator.fold.DeduplicateOperatorApplication;
import de.firemage.autograder.core.integrated.evaluator.fold.EvaluateLiteralOperations;
import de.firemage.autograder.core.integrated.evaluator.fold.EvaluatePartialLiteralOperations;
import de.firemage.autograder.core.integrated.evaluator.fold.Fold;
import de.firemage.autograder.core.integrated.evaluator.fold.InferOperatorTypes;
import de.firemage.autograder.core.integrated.evaluator.fold.InlineVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.eval.PartialEvaluator;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

public class Evaluator
extends CtScanner
implements PartialEvaluator {
    private CtElement root;
    private final Fold fold;

    public Evaluator(Fold fold) {
        this.fold = fold;
    }

    public Evaluator(Fold firstFold, Fold ... other) {
        this(ChainedFold.chain(firstFold, other));
    }

    public Evaluator() {
        this(InferOperatorTypes.create(), InlineVariableRead.create(), DeduplicateOperatorApplication.create(), EvaluatePartialLiteralOperations.create(), EvaluateLiteralOperations.create());
    }

    public <R extends CtElement> R evaluate(R ctElement) {
        CtElement result = this.evaluateUnsafe(ctElement.clone());
        if (result.isParentInitialized() && result.getParent() != null) {
            throw new IllegalStateException("The parent of the root node has not been detached");
        }
        return (R)result;
    }

    private <R extends CtElement> R evaluateUnsafe(R ctElement) {
        this.root = ctElement;
        ctElement.accept((CtVisitor)this);
        return (R)this.root;
    }

    private void setResult(CtElement result, CtElement ctElement) {
        if (result == ctElement) {
            return;
        }
        CtElement replacement = result.clone();
        if (ctElement == this.root) {
            replacement.setParent(null);
            this.root = replacement;
        } else {
            ctElement.replace(replacement);
        }
    }

    protected void enter(CtElement ctElement) {
        this.setResult(this.fold.enter(ctElement), ctElement);
    }

    protected void exit(CtElement ctElement) {
        this.setResult(this.fold.exit(ctElement), ctElement);
    }
}

