/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import de.firemage.autograder.core.integrated.CtElementStream;
import de.firemage.autograder.core.integrated.SpoonUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import spoon.processing.FactoryAccessor;
import spoon.reflect.CtModel;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtTypePattern;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

public class UsesFinder {
    private static final String METADATA_KEY = "autograder_uses";
    private final UsesScanner scanner = new UsesScanner();

    private UsesFinder(CtModel model) {
        model.getRootPackage().accept((CtVisitor)this.scanner);
    }

    public static void buildFor(CtModel model) {
        UsesFinder uses = new UsesFinder(model);
        model.getRootPackage().putMetadata(METADATA_KEY, (Object)uses);
    }

    private static UsesFinder getFor(FactoryAccessor factoryAccessor) {
        UsesFinder uses = (UsesFinder)SpoonUtil.getRootPackage(factoryAccessor).getMetadata(METADATA_KEY);
        if (uses == null) {
            throw new IllegalArgumentException("No uses information available for this model");
        }
        return uses;
    }

    public static CtElementStream<CtElement> getAllUses(CtNamedElement element) {
        if (element instanceof CtVariable) {
            CtVariable variable = (CtVariable)element;
            return UsesFinder.variableUses(variable).asUntypedStream();
        }
        if (element instanceof CtTypeParameter) {
            CtTypeParameter typeParameter = (CtTypeParameter)element;
            return UsesFinder.typeParameterUses(typeParameter).asUntypedStream();
        }
        if (element instanceof CtExecutable) {
            CtExecutable executable = (CtExecutable)element;
            return UsesFinder.executableUses(executable).asUntypedStream();
        }
        if (element instanceof CtType) {
            CtType type = (CtType)element;
            return UsesFinder.typeUses(type).asUntypedStream();
        }
        throw new IllegalArgumentException("Unsupported element: " + element.getClass().getName());
    }

    public static CtElementStream<CtVariableAccess<?>> variableUses(CtVariable<?> variable) {
        return CtElementStream.of(UsesFinder.getFor(variable).scanner.variableUses.getOrDefault(variable, List.of())).assumeElementType();
    }

    public static CtElementStream<CtVariableWrite<?>> variableWrites(CtVariable<?> variable) {
        return CtElementStream.of(UsesFinder.getFor(variable).scanner.variableUses.getOrDefault(variable, List.of())).assumeElementType().ofType(CtVariableWrite.class);
    }

    public static CtElementStream<CtVariableRead<?>> variableReads(CtVariable<?> variable) {
        return CtElementStream.of(UsesFinder.getFor(variable).scanner.variableUses.getOrDefault(variable, List.of())).assumeElementType().ofType(CtVariableRead.class);
    }

    public static CtElementStream<CtTypeParameterReference> typeParameterUses(CtTypeParameter typeParameter) {
        return CtElementStream.of(UsesFinder.getFor((FactoryAccessor)typeParameter).scanner.typeParameterUses.getOrDefault(typeParameter, List.of()));
    }

    public static CtElementStream<CtElement> executableUses(CtExecutable<?> executable) {
        return CtElementStream.of(UsesFinder.getFor(executable).scanner.executableUses.getOrDefault(executable, List.of()));
    }

    public static CtElementStream<CtTypeReference<?>> typeUses(CtType<?> type) {
        return CtElementStream.of(UsesFinder.getFor(type).scanner.typeUses.getOrDefault(type, List.of())).assumeElementType();
    }

    private static CtElementStream<CtType<?>> supertypesOf(CtType<?> type) {
        return CtElementStream.of(UsesFinder.getFor(type).scanner.supertypes.getOrDefault(type, new LinkedHashSet())).assumeElementType();
    }

    public static boolean isSubtypeOf(CtType<?> parentType, CtType<?> potentialSubtype) {
        return parentType == potentialSubtype || UsesFinder.supertypesOf(parentType).anyMatch(type -> potentialSubtype == type) || parentType.isSubtypeOf(potentialSubtype.getReference());
    }

    public static CtElementStream<CtType<?>> subtypesOf(CtType<?> type, boolean includeSelf) {
        Stream<Object> selfStream = includeSelf ? Stream.of(type) : Stream.empty();
        return CtElementStream.concat(selfStream, CtElementStream.of(UsesFinder.getFor(type).scanner.subtypes.getOrDefault(type, new LinkedHashSet())).assumeElementType());
    }

    public static boolean isAccessingVariable(CtVariable<?> ctVariable, CtVariableAccess<?> ctVariableAccess) {
        return UsesFinder.getDeclaredVariable(ctVariableAccess) == ctVariable;
    }

    public static CtVariable<?> getDeclaredVariable(CtVariableAccess<?> ctVariableAccess) {
        return UsesFinder.getFor(ctVariableAccess).scanner.variableAccessDeclarations.getOrDefault(ctVariableAccess, null);
    }

    private static class UsesScanner
    extends CtScanner {
        private final Map<CtVariable, List<CtVariableAccess>> variableUses = new IdentityHashMap<CtVariable, List<CtVariableAccess>>();
        private final Map<CtVariableAccess, CtVariable> variableAccessDeclarations = new IdentityHashMap<CtVariableAccess, CtVariable>();
        private final Map<CtTypeParameter, List<CtTypeParameterReference>> typeParameterUses = new IdentityHashMap<CtTypeParameter, List<CtTypeParameterReference>>();
        private final Map<CtExecutable, List<CtElement>> executableUses = new IdentityHashMap<CtExecutable, List<CtElement>>();
        private final Map<CtType, List<CtTypeReference>> typeUses = new IdentityHashMap<CtType, List<CtTypeReference>>();
        private final Map<CtType, Set<CtType>> subtypes = new IdentityHashMap<CtType, Set<CtType>>();
        private final Map<CtType, Set<CtType>> supertypes = new IdentityHashMap<CtType, Set<CtType>>();
        private final Deque<Map<String, CtVariable>> instanceofPatternVariables = new ArrayDeque<Map<String, CtVariable>>();

        private UsesScanner() {
        }

        public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
            this.recordVariableAccess((CtVariableAccess<?>)variableRead);
            super.visitCtVariableRead(variableRead);
        }

        public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
            this.recordVariableAccess((CtVariableAccess<?>)variableWrite);
            super.visitCtVariableWrite(variableWrite);
        }

        public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
            this.recordVariableAccess((CtVariableAccess<?>)fieldRead);
            super.visitCtFieldRead(fieldRead);
        }

        public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
            this.recordVariableAccess((CtVariableAccess<?>)fieldWrite);
            super.visitCtFieldWrite(fieldWrite);
        }

        public <T> void visitCtInvocation(CtInvocation<T> invocation) {
            CtExpression ctExpression = invocation.getTarget();
            if (ctExpression instanceof CtVariableAccess) {
                CtVariableAccess reference = (CtVariableAccess)ctExpression;
                this.recordVariableAccess(reference);
            }
            this.recordExecutableReference(invocation.getExecutable(), (CtElement)invocation);
            super.visitCtInvocation(invocation);
        }

        public void visitCtTypePattern(CtTypePattern pattern) {
            CtLocalVariable variable = pattern.getVariable();
            this.instanceofPatternVariables.peek().put(variable.getSimpleName(), (CtVariable)variable);
            super.visitCtTypePattern(pattern);
        }

        public void visitCtTypeParameterReference(CtTypeParameterReference reference) {
            this.recordTypeParameterReference(reference);
            super.visitCtTypeParameterReference(reference);
        }

        public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
            this.recordExecutableReference(expression.getExecutable(), (CtElement)expression);
            super.visitCtExecutableReferenceExpression(expression);
        }

        public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
            this.recordExecutableReference(ctConstructorCall.getExecutable(), (CtElement)ctConstructorCall);
            super.visitCtConstructorCall(ctConstructorCall);
        }

        public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
            this.recordTypeReference(reference);
            super.visitCtTypeReference(reference);
        }

        public <R> void visitCtBlock(CtBlock<R> block) {
            this.instanceofPatternVariables.push(new HashMap());
            super.visitCtBlock(block);
            this.instanceofPatternVariables.pop();
        }

        public <T> void visitCtClass(CtClass<T> ctClass) {
            this.recordCtType((CtType<?>)ctClass);
            super.visitCtClass(ctClass);
        }

        public <T> void visitCtInterface(CtInterface<T> ctInterface) {
            this.recordCtType((CtType<?>)ctInterface);
            super.visitCtInterface(ctInterface);
        }

        private void recordVariableAccess(CtVariableAccess<?> variableAccess) {
            CtVariable variable = variableAccess.getVariable().getDeclaration();
            if (variable == null) {
                if (variableAccess.getVariable() instanceof CtLocalVariableReference) {
                    Map<String, CtVariable> scope;
                    Iterator<Map<String, CtVariable>> iterator = this.instanceofPatternVariables.iterator();
                    while (iterator.hasNext() && (variable = (scope = iterator.next()).get(variableAccess.getVariable().getSimpleName())) == null) {
                    }
                } else {
                    CtVariableReference ctVariableReference = variableAccess.getVariable();
                    if (ctVariableReference instanceof CtFieldReference) {
                        CtFieldReference fieldReference = (CtFieldReference)ctVariableReference;
                        variable = fieldReference.getFieldDeclaration();
                    }
                }
            }
            if (variable != null) {
                List accesses = this.variableUses.computeIfAbsent(variable, k -> new ArrayList());
                accesses.add(variableAccess);
                this.variableAccessDeclarations.put(variableAccess, variable);
            }
        }

        private void recordTypeParameterReference(CtTypeParameterReference reference) {
            CtTypeParameter parameter = reference.getDeclaration();
            if (parameter != null) {
                List uses = this.typeParameterUses.computeIfAbsent(parameter, k -> new ArrayList());
                uses.add(reference);
            }
        }

        private void recordExecutableReference(CtExecutableReference reference, CtElement referencingElement) {
            CtExecutable executable = reference.getExecutableDeclaration();
            if (executable != null) {
                List uses = this.executableUses.computeIfAbsent(executable, k -> new ArrayList());
                uses.add(referencingElement);
            }
        }

        private void recordTypeReference(CtTypeReference reference) {
            CtType type;
            if (reference instanceof CtArrayTypeReference) {
                CtArrayTypeReference arrayType = (CtArrayTypeReference)reference;
                reference = arrayType.getArrayType();
            }
            if ((type = reference.getTypeDeclaration()) != null) {
                List uses = this.typeUses.computeIfAbsent(type, k -> new ArrayList());
                uses.add(reference);
            }
        }

        private void recordCtType(CtType<?> ctType) {
            for (CtTypeReference superType = ctType.getSuperclass(); superType != null && superType.getTypeDeclaration() != null; superType = superType.getSuperclass()) {
                this.subtypes.computeIfAbsent(superType.getTypeDeclaration(), k -> new LinkedHashSet()).add(ctType);
                this.supertypes.computeIfAbsent(ctType, k -> new LinkedHashSet()).add(superType.getTypeDeclaration());
            }
            HashSet<CtTypeReference> visited = new HashSet<CtTypeReference>();
            LinkedList superInterfaces = new LinkedList(ctType.getSuperInterfaces());
            while (!superInterfaces.isEmpty()) {
                CtTypeReference superInterface = (CtTypeReference)superInterfaces.poll();
                if (!visited.add(superInterface)) continue;
                if (superInterface.getTypeDeclaration() != null) {
                    this.subtypes.computeIfAbsent(superInterface.getTypeDeclaration(), k -> new LinkedHashSet()).add(ctType);
                }
                superInterfaces.addAll(superInterface.getSuperInterfaces());
            }
        }
    }
}

