/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import spoon.reflect.CtModel;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

public final class MethodHierarchy {
    private static final String METADATA_KEY = "autograder_method_hierarchy";
    private final IdentityHashMap<CtMethod<?>, SurroundingMethods> methodHierarchy = new IdentityHashMap();

    private MethodHierarchy(CtModel model) {
        model.getRootPackage().accept((CtVisitor)new CtScanner(){

            public <T> void visitCtMethod(CtMethod<T> method) {
                if (!method.isStatic() && !method.isPrivate()) {
                    MethodHierarchy.this.methodHierarchy.computeIfAbsent(method, m -> SurroundingMethods.empty());
                    MethodHierarchy.this.searchSuperTypesForSuperMethod(method.getDeclaringType(), method, Collections.newSetFromMap(new IdentityHashMap()));
                }
                super.visitCtMethod(method);
            }

            public <T> void visitCtLambda(CtLambda<T> lambda) {
                CtMethod overriddenMethod = lambda.getOverriddenMethod();
                if (overriddenMethod != null) {
                    MethodHierarchy.this.methodHierarchy.computeIfAbsent(overriddenMethod, (Function<CtMethod, SurroundingMethods>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$visitCtLambda$1(spoon.reflect.declaration.CtMethod ), (Lspoon/reflect/declaration/CtMethod;)Lde/firemage/autograder/core/integrated/MethodHierarchy$SurroundingMethods;)()).overridingMethods.add(new MethodOrLambda<T>(lambda));
                }
                super.visitCtLambda(lambda);
            }

            private static /* synthetic */ SurroundingMethods lambda$visitCtLambda$1(CtMethod m) {
                return SurroundingMethods.empty();
            }
        });
    }

    public static void buildFor(CtModel model) {
        MethodHierarchy methodHierarchy = new MethodHierarchy(model);
        model.getRootPackage().putMetadata(METADATA_KEY, (Object)methodHierarchy);
    }

    public static MethodHierarchy getFor(CtElement element) {
        MethodHierarchy methodHierarchy = (MethodHierarchy)element.getFactory().getModel().getRootPackage().getMetadata(METADATA_KEY);
        if (methodHierarchy == null) {
            throw new IllegalStateException("MethodHierarchy not built for this model");
        }
        return methodHierarchy;
    }

    public static Set<MethodOrLambda<?>> getDirectSuperMethods(CtMethod<?> method) {
        SurroundingMethods surroundingMethods = MethodHierarchy.getFor(method).methodHierarchy.get(method);
        if (surroundingMethods == null) {
            return Set.of();
        }
        return Collections.unmodifiableSet(surroundingMethods.superMethods);
    }

    public static Set<MethodOrLambda<?>> getDirectOverridingMethods(CtMethod<?> method) {
        SurroundingMethods surroundingMethods = MethodHierarchy.getFor(method).methodHierarchy.get(method);
        if (surroundingMethods == null) {
            return Set.of();
        }
        return Collections.unmodifiableSet(surroundingMethods.overridingMethods);
    }

    public static Stream<MethodOrLambda<?>> streamAllOverridingMethods(CtMethod<?> method) {
        if (method == null) {
            return Stream.empty();
        }
        SurroundingMethods surroundingMethods = MethodHierarchy.getFor(method).methodHierarchy.get(method);
        if (surroundingMethods == null) {
            return Stream.of(new MethodOrLambda[0]);
        }
        return surroundingMethods.overridingMethods.stream().flatMap(m -> Stream.concat(Stream.of(m), MethodHierarchy.streamAllOverridingMethods(m.getMethod())));
    }

    public static boolean isOverridingMethod(CtMethod<?> method) {
        SurroundingMethods surroundingMethods = MethodHierarchy.getFor(method).methodHierarchy.get(method);
        return surroundingMethods != null && !surroundingMethods.superMethods.isEmpty();
    }

    public static boolean isOverriddenMethod(CtMethod<?> method) {
        SurroundingMethods surroundingMethods = MethodHierarchy.getFor(method).methodHierarchy.get(method);
        return surroundingMethods != null && !surroundingMethods.overridingMethods.isEmpty();
    }

    private void searchSuperTypesForSuperMethod(CtType<?> currentType, CtMethod<?> subMethod, Set<CtType<?>> visitedTypes) {
        if (currentType == null || visitedTypes.contains(currentType)) {
            return;
        }
        visitedTypes.add(currentType);
        CtTypeReference superType = currentType.getSuperclass();
        if (currentType.getSuperclass() == null) {
            superType = currentType.getFactory().Type().objectType();
        }
        this.searchSuperMethodInType(superType.getTypeDeclaration(), subMethod, visitedTypes);
        for (CtTypeReference superInterface : currentType.getSuperInterfaces()) {
            this.searchSuperMethodInType(superInterface.getTypeDeclaration(), subMethod, visitedTypes);
        }
    }

    private void searchSuperMethodInType(CtType<?> currentType, CtMethod<?> subMethod, Set<CtType<?>> visitedTypes) {
        for (CtMethod method : currentType.getMethods()) {
            if (method.isStatic() || method.isPrivate() || !subMethod.isOverriding(method)) continue;
            this.methodHierarchy.computeIfAbsent(method, (Function<CtMethod, SurroundingMethods>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$searchSuperMethodInType$1(spoon.reflect.declaration.CtMethod ), (Lspoon/reflect/declaration/CtMethod;)Lde/firemage/autograder/core/integrated/MethodHierarchy$SurroundingMethods;)()).overridingMethods.add(new MethodOrLambda(subMethod));
            this.methodHierarchy.get(subMethod).superMethods.add(new MethodOrLambda(method));
            return;
        }
        this.searchSuperTypesForSuperMethod(currentType, subMethod, visitedTypes);
    }

    private static /* synthetic */ SurroundingMethods lambda$searchSuperMethodInType$1(CtMethod k) {
        return SurroundingMethods.empty();
    }

    private record SurroundingMethods(Set<MethodOrLambda<?>> superMethods, Set<MethodOrLambda<?>> overridingMethods) {
        public static SurroundingMethods empty() {
            return new SurroundingMethods(new HashSet(), new HashSet());
        }
    }

    public static class MethodOrLambda<T> {
        private CtMethod<T> method;
        private CtLambda<T> lambda;

        public MethodOrLambda(CtMethod<T> method) {
            this.method = method;
        }

        public MethodOrLambda(CtLambda<T> lambda) {
            this.lambda = lambda;
        }

        public CtMethod<T> getMethod() {
            return this.method;
        }

        public CtLambda<T> getLambda() {
            return this.lambda;
        }

        public CtExecutable<T> getExecutable() {
            return this.method != null ? this.method : this.lambda;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodOrLambda that = (MethodOrLambda)o;
            return this.method == that.method && this.lambda == that.lambda;
        }

        public int hashCode() {
            return Objects.hash(System.identityHashCode(this.method), System.identityHashCode(this.lambda));
        }
    }
}

