/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import de.firemage.autograder.api.AbstractTempLocation;
import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.CodeLinter;
import de.firemage.autograder.core.LinterStatus;
import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.file.UploadedFile;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.CtModel;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;

public class IntegratedAnalysis
implements CodeLinter<IntegratedCheck> {
    private static final boolean IS_IN_DEBUG_MODE = SpoonUtil.isInJunitTest();
    private static final String INITIAL_INTEGRITY_CHECK_NAME = "StaticAnalysis-Constructor";
    private static final boolean ENSURE_NO_ORPHANS = false;
    private static final boolean ENSURE_NO_MODEL_CHANGES = false;
    private static final Logger logger = LoggerFactory.getLogger(IntegratedAnalysis.class);
    private UploadedFile file;
    private CtModel originalModel;
    private StaticAnalysis staticAnalysis;
    private static final Set<CtElement> alreadyInvalidElements = Collections.newSetFromMap(new IdentityHashMap());

    private void init(UploadedFile file) {
        this.file = file;
        this.originalModel = IS_IN_DEBUG_MODE ? file.copy().getModel().getModel() : null;
        this.staticAnalysis = new StaticAnalysis(file.getModel(), file.getCompilationResult());
        if (IS_IN_DEBUG_MODE && this.originalModel == this.staticAnalysis.getModel()) {
            throw new IllegalStateException("The model was not cloned");
        }
        this.assertModelIntegrity(INITIAL_INTEGRITY_CHECK_NAME);
    }

    @Override
    public Class<IntegratedCheck> supportedCheckType() {
        return IntegratedCheck.class;
    }

    @Override
    public List<Problem> lint(UploadedFile submission, AbstractTempLocation tempLocation, ClassLoader classLoader, List<IntegratedCheck> checks, Consumer<Translatable> statusConsumer) {
        this.init(submission);
        statusConsumer.accept(LinterStatus.BUILDING_CODE_MODEL.getMessage());
        this.staticAnalysis.getCodeModel().ensureModelBuild();
        statusConsumer.accept(LinterStatus.RUNNING_INTEGRATED_CHECKS.getMessage());
        ArrayList<Problem> result = new ArrayList<Problem>();
        for (IntegratedCheck check : checks) {
            long beforeTime = System.nanoTime();
            result.addAll(check.run(this.staticAnalysis, this.file.getSource()));
            long afterTime = System.nanoTime();
            logger.info("Completed check " + check.getClass().getSimpleName() + " in " + (afterTime - beforeTime) / 1000000L + "ms");
            this.assertModelIntegrity(check.getClass().getSimpleName());
        }
        return result;
    }

    private void assertModelIntegrity(String checkName) {
        List<CtElement> orphans;
        CtModel linterModel = this.staticAnalysis.getModel();
        if (IS_IN_DEBUG_MODE) {
            List<ParentChecker.InvalidElement> invalidElements = ParentChecker.checkConsistency((CtElement)linterModel.getUnnamedModule());
            if (checkName.equals(INITIAL_INTEGRITY_CHECK_NAME)) {
                invalidElements.stream().map(ParentChecker.InvalidElement::element).forEach(alreadyInvalidElements::add);
            }
            invalidElements.removeIf(elem -> alreadyInvalidElements.contains(elem.element()));
            if (!invalidElements.isEmpty()) {
                throw new IllegalStateException("The model was modified by %s, %d elements have invalid parents:%n%s".formatted(checkName, invalidElements.size(), invalidElements.stream().map(ParentChecker.InvalidElement::toString).limit(5L).collect(Collectors.joining(System.lineSeparator()))));
            }
        }
        if (IS_IN_DEBUG_MODE && !this.isModelEqualTo(this.originalModel, linterModel)) {
            throw new IllegalStateException("The model was changed by the check: %s".formatted(checkName));
        }
        if (IS_IN_DEBUG_MODE && !(orphans = IntegratedAnalysis.findOrphans(linterModel)).isEmpty()) {
            throw new IllegalStateException("The check %s introduced new elements into the model without parents (did you forget to clone before passing the element to a setter?): %s".formatted(checkName, orphans.stream().map(element -> "%s(\"%s\")".formatted(element.getClass().getSimpleName(), element)).toList()));
        }
    }

    private boolean isModelEqualTo(CtModel original, CtModel toCheck) {
        return original.getUnnamedModule().equals(toCheck.getUnnamedModule());
    }

    private static boolean isOrphan(CtElement ctElement) {
        CtPackageReference ctPackage;
        if (ctElement instanceof CtPackageReference && (ctPackage = (CtPackageReference)ctElement).getQualifiedName().startsWith("java.")) {
            return false;
        }
        if (ctElement instanceof CtTypeReference || ctElement instanceof CtLiteral || ctElement instanceof CtPackageReference) {
            return false;
        }
        CtModule root = ctElement.getFactory().getModel().getUnnamedModule();
        if (root == ctElement) {
            return false;
        }
        CtElement parent2 = ctElement;
        for (CtElement parent2 : SpoonUtil.parents(ctElement)) {
        }
        return parent2 != root;
    }

    private static List<CtElement> findOrphans(CtModel ctModel) {
        return ctModel.getElements(IntegratedAnalysis::isOrphan);
    }

    public StaticAnalysis getStaticAnalysis() {
        return this.staticAnalysis;
    }

    private static final class ParentChecker
    extends CtScanner {
        private final List<InvalidElement> invalidElements = new ArrayList<InvalidElement>();
        private final Deque<CtElement> stack = new ArrayDeque<CtElement>();

        private ParentChecker() {
        }

        public static List<InvalidElement> checkConsistency(CtElement ctElement) {
            ParentChecker parentChecker = new ParentChecker();
            parentChecker.scan(ctElement);
            return parentChecker.invalidElements;
        }

        public void enter(CtElement element) {
            if (!(this.stack.isEmpty() || element.isParentInitialized() && element.getParent() == this.stack.peek())) {
                this.invalidElements.add(new InvalidElement(element, this.stack));
            }
            this.stack.push(element);
        }

        protected void exit(CtElement e) {
            this.stack.pop();
        }

        public record InvalidElement(CtElement element, Deque<CtElement> stack) {
            public InvalidElement {
                stack = new ArrayDeque<CtElement>(stack);
            }

            public String reason() {
                Object object;
                CtElement ctElement = this.element;
                if (ctElement instanceof CtNamedElement) {
                    CtNamedElement ctNamedElement = (CtNamedElement)ctElement;
                    object = "-" + ctNamedElement.getSimpleName();
                } else {
                    object = "";
                }
                String name = object;
                return (this.element.isParentInitialized() ? "inconsistent" : "null") + " parent for " + this.element.getClass() + name + " - " + this.element.getPosition() + " - " + this.stack.peek();
            }

            public String dumpStack() {
                ArrayList<CallSite> output = new ArrayList<CallSite>();
                for (CtElement ctElement : this.stack) {
                    output.add((CallSite)((Object)("    " + ctElement.getClass().getSimpleName() + " " + (ctElement.getPosition().isValidPosition() ? String.valueOf(ctElement.getPosition()) : "(?)"))));
                }
                return String.join((CharSequence)System.lineSeparator(), output);
            }

            @Override
            public String toString() {
                return "%s%n%s".formatted(this.reason(), this.dumpStack());
            }

            @Override
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof InvalidElement)) {
                    return false;
                }
                InvalidElement that = (InvalidElement)object;
                return this.element == that.element();
            }

            @Override
            public int hashCode() {
                return System.identityHashCode(this.element);
            }
        }
    }
}

