/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import de.firemage.autograder.core.integrated.SpoonUtil;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.Range;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;

public record CtRange<T extends Comparable<T>>(CtExpression<T> ctExpression, BinaryOperatorKind operator, CtLiteral<T> ctLiteral) {
    public static Optional<CtRange<Character>> ofCharRange(CtBinaryOperator<Boolean> ctBinaryOperator) {
        return CtRange.of(ctBinaryOperator, Character.class, Character.TYPE);
    }

    private static <T extends Comparable<T>> Optional<CtRange<T>> of(CtBinaryOperator<Boolean> ctBinaryOperator, Class<?> ... expectedTypes) {
        Predicate<CtExpression> isLiteral = expr -> {
            CtLiteral ctLiteral;
            return expr instanceof CtLiteral && SpoonUtil.isTypeEqualTo((ctLiteral = (CtLiteral)expr).getType(), expectedTypes);
        };
        CtBinaryOperator<Boolean> result = SpoonUtil.normalizeBy((left, right) -> isLiteral.test((CtExpression)left) && !isLiteral.test((CtExpression)right), ctBinaryOperator);
        if (!isLiteral.test(result.getRightHandOperand())) {
            return Optional.empty();
        }
        return Optional.of(new CtRange<T>(result.getLeftHandOperand(), result.getKind(), (CtLiteral)result.getRightHandOperand()));
    }

    public Range<T> toRange() {
        if (this.operator == BinaryOperatorKind.LE) {
            Comparable lowerBound = (Comparable)SpoonUtil.minimumValue(this.ctLiteral).getValue();
            CtExpression<T> ctExpression = SpoonUtil.resolveCtExpression(this.ctExpression);
            if (ctExpression instanceof CtLiteral) {
                CtLiteral exprLiteral = (CtLiteral)ctExpression;
                lowerBound = (Comparable)exprLiteral.getValue();
            }
            return Range.of((Comparable)lowerBound, (Comparable)((Comparable)this.ctLiteral.getValue()));
        }
        if (this.operator == BinaryOperatorKind.GE) {
            Comparable upperBound = (Comparable)SpoonUtil.maximumValue(this.ctLiteral).getValue();
            CtExpression<T> ctExpression = SpoonUtil.resolveCtExpression(this.ctExpression);
            if (ctExpression instanceof CtLiteral) {
                CtLiteral exprLiteral = (CtLiteral)ctExpression;
                upperBound = (Comparable)exprLiteral.getValue();
            }
            return Range.of((Comparable)((Comparable)this.ctLiteral.getValue()), (Comparable)upperBound);
        }
        throw new IllegalStateException("Unsupported operator: " + this.operator);
    }
}

