/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import de.firemage.autograder.core.integrated.SpoonUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import spoon.reflect.declaration.CtElement;

public class CtElementStream<T extends CtElement>
implements Stream<T> {
    private final Stream<T> baseStream;

    public static <T extends CtElement> CtElementStream<T> fromStream(Stream<T> stream) {
        return new CtElementStream<T>(stream);
    }

    public static <T extends CtElement> CtElementStream<T> of(T element) {
        return new CtElementStream<T>(Stream.of(element));
    }

    @SafeVarargs
    public static <T extends CtElement> CtElementStream<T> of(T ... elements) {
        return new CtElementStream<T>(Stream.of(elements));
    }

    public static <T extends CtElement> CtElementStream<T> of(Iterable<T> elements) {
        return new CtElementStream<T>(StreamSupport.stream(elements.spliterator(), false));
    }

    public static <T extends CtElement> CtElementStream<T> empty() {
        return new CtElementStream(Stream.empty());
    }

    public static <T extends CtElement> CtElementStream<T> concat(Stream<? extends T> a, Stream<? extends T> b) {
        return new CtElementStream<T>(Stream.concat(a, b));
    }

    private CtElementStream(Stream<T> baseStream) {
        this.baseStream = baseStream;
    }

    public Stream<T> toStream() {
        return this;
    }

    public <R extends CtElement> CtElementStream<R> mapToElement(Function<? super T, ? extends R> function) {
        return new CtElementStream<R>(this.baseStream.map(function));
    }

    public <R extends T> CtElementStream<R> ofType(Class<R> type) {
        return new CtElementStream<CtElement>(this.baseStream.filter(type::isInstance).map(type::cast));
    }

    public <R extends T> CtElementStream<R> assumeElementType() {
        return this;
    }

    public CtElementStream<CtElement> asUntypedStream() {
        return this;
    }

    public CtElementStream<T> withDirectParent(CtElement parent) {
        return new CtElementStream<CtElement>(this.baseStream.filter((? super T e) -> e.getParent() == parent));
    }

    public CtElementStream<T> withDirectParent(Class<? extends CtElement> parent) {
        return new CtElementStream<CtElement>(this.baseStream.filter((? super T e) -> parent.isInstance(e.getParent())));
    }

    public CtElementStream<T> nestedIn(CtElement parent) {
        return this.filter((T e) -> SpoonUtil.isNestedOrSame(e, parent));
    }

    public CtElementStream<T> nestedInAny(CtElement ... parents) {
        return this.nestedInAny(Arrays.asList(parents));
    }

    public CtElementStream<T> nestedInAny(Collection<? extends CtElement> parents) {
        if (parents.isEmpty()) {
            return CtElementStream.empty();
        }
        Set potentialParents = Collections.newSetFromMap(new IdentityHashMap());
        potentialParents.addAll(parents);
        return this.filter((T e) -> SpoonUtil.isAnyNestedOrSame(e, potentialParents));
    }

    public CtElementStream<T> nestedIn(Class<? extends CtElement> parentType) {
        return this.filter((T e) -> parentType.isInstance(e) || e.getParent(parentType) != null);
    }

    public CtElementStream<T> notNestedIn(Class<? extends CtElement> parentType) {
        return this.filter((T e) -> !parentType.isInstance(e) && e.getParent(parentType) == null);
    }

    public boolean hasAny() {
        return this.baseStream.findAny().isPresent();
    }

    public boolean hasAnyMatch(Predicate<? super T> predicate) {
        return new CtElementStream<T>(this.baseStream.filter(predicate)).hasAny();
    }

    public boolean hasAnyAndAllMatch(Predicate<? super T> predicate) {
        boolean[] isEmpty = new boolean[]{true};
        return this.allMatch(element -> {
            isEmpty[0] = false;
            return predicate.test(element);
        }) && !isEmpty[0];
    }

    public boolean hasNone() {
        return this.baseStream.findAny().isEmpty();
    }

    public CtElementStream<T> filterDirectParent(Predicate<? super CtElement> filter) {
        return new CtElementStream<CtElement>(this.baseStream.filter((? super T e) -> filter.test(e.getParent())));
    }

    public <P extends CtElement> CtElementStream<T> filterDirectParent(Class<P> parentType, Predicate<P> filter) {
        return new CtElementStream<CtElement>(this.baseStream.filter((? super T e) -> parentType.isInstance(e.getParent()) && filter.test(e.getParent())));
    }

    public <P extends CtElement> CtElementStream<T> filterIndirectParent(Class<P> parentType, Predicate<? super CtElement> filter) {
        return new CtElementStream<CtElement>(this.baseStream.filter((? super T e) -> filter.test(e.getParent(parentType))));
    }

    public Iterable<T> iterable() {
        return this.baseStream::iterator;
    }

    @Override
    public CtElementStream<T> filter(Predicate<? super T> predicate) {
        return new CtElementStream<T>(this.baseStream.filter(predicate));
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> function) {
        return this.baseStream.map(function);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> toIntFunction) {
        return this.baseStream.mapToInt(toIntFunction);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> toLongFunction) {
        return this.baseStream.mapToLong(toLongFunction);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        return this.baseStream.mapToDouble(toDoubleFunction);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> function) {
        return this.baseStream.flatMap(function);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> function) {
        return this.baseStream.flatMapToInt(function);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> function) {
        return this.baseStream.flatMapToLong(function);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> function) {
        return this.baseStream.flatMapToDouble(function);
    }

    @Override
    public <R> Stream<R> mapMulti(BiConsumer<? super T, ? super Consumer<R>> mapper) {
        return this.baseStream.mapMulti(mapper);
    }

    @Override
    public IntStream mapMultiToInt(BiConsumer<? super T, ? super IntConsumer> mapper) {
        return this.baseStream.mapMultiToInt(mapper);
    }

    @Override
    public LongStream mapMultiToLong(BiConsumer<? super T, ? super LongConsumer> mapper) {
        return this.baseStream.mapMultiToLong(mapper);
    }

    @Override
    public DoubleStream mapMultiToDouble(BiConsumer<? super T, ? super DoubleConsumer> mapper) {
        return this.baseStream.mapMultiToDouble(mapper);
    }

    @Override
    public Stream<T> distinct() {
        return this.baseStream.distinct();
    }

    @Override
    public Stream<T> sorted() {
        return this.baseStream.sorted();
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        return this.baseStream.sorted(comparator);
    }

    @Override
    public Stream<T> peek(Consumer<? super T> consumer) {
        return this.baseStream.peek(consumer);
    }

    @Override
    public Stream<T> limit(long l) {
        return this.baseStream.limit(l);
    }

    @Override
    public Stream<T> skip(long l) {
        return this.baseStream.skip(l);
    }

    @Override
    public Stream<T> takeWhile(Predicate<? super T> predicate) {
        return this.baseStream.takeWhile(predicate);
    }

    @Override
    public Stream<T> dropWhile(Predicate<? super T> predicate) {
        return this.baseStream.dropWhile(predicate);
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        this.baseStream.forEach(consumer);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> consumer) {
        this.baseStream.forEachOrdered(consumer);
    }

    @Override
    public Object[] toArray() {
        return this.baseStream.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> intFunction) {
        return this.baseStream.toArray(intFunction);
    }

    @Override
    public T reduce(T t, BinaryOperator<T> binaryOperator) {
        return (T)((CtElement)this.baseStream.reduce(t, binaryOperator));
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> binaryOperator) {
        return this.baseStream.reduce(binaryOperator);
    }

    @Override
    public <U> U reduce(U u, BiFunction<U, ? super T, U> biFunction, BinaryOperator<U> binaryOperator) {
        return this.baseStream.reduce(u, biFunction, binaryOperator);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> biConsumer, BiConsumer<R, R> biConsumer1) {
        return this.baseStream.collect(supplier, biConsumer, biConsumer1);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.baseStream.collect(collector);
    }

    @Override
    public List<T> toList() {
        return this.baseStream.toList();
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.baseStream.min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.baseStream.max(comparator);
    }

    @Override
    public long count() {
        return this.baseStream.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.baseStream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.baseStream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.baseStream.noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.baseStream.findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.baseStream.findAny();
    }

    @Override
    public Iterator<T> iterator() {
        return this.baseStream.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.baseStream.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.baseStream.isParallel();
    }

    @Override
    public Stream<T> sequential() {
        return (Stream)this.baseStream.sequential();
    }

    @Override
    public Stream<T> parallel() {
        return (Stream)this.baseStream.parallel();
    }

    @Override
    public Stream<T> unordered() {
        return (Stream)this.baseStream.unordered();
    }

    @Override
    public Stream<T> onClose(Runnable runnable) {
        return (Stream)this.baseStream.onClose(runnable);
    }

    @Override
    public void close() {
        this.baseStream.close();
    }
}

