/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.utils;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Option<T>
extends Iterable<T> {
    public static <T> Option<T> ofNullable(T value) {
        return value == null ? new None() : new Some<T>(value);
    }

    public static <T> Option<T> some(T value) {
        Objects.requireNonNull(value, "Value must not be null.");
        return new Some<T>(value);
    }

    public static <T> Option<T> none() {
        return new None();
    }

    default public T unwrap() {
        Option option = this;
        if (option instanceof Some) {
            Some someValue = (Some)option;
            return someValue.value;
        }
        if (this instanceof None) {
            throw new IllegalStateException("Expected Some value, but got None.");
        }
        throw new IllegalArgumentException();
    }

    default public boolean isSome() {
        return this instanceof Some;
    }

    default public <U> Option<U> map(Function<T, U> function) {
        Option option = this;
        if (option instanceof Some) {
            Some someValue = (Some)option;
            return new Some<U>(function.apply(someValue.value));
        }
        if (this instanceof None) {
            return new None();
        }
        throw new IllegalArgumentException();
    }

    default public T nullable() {
        Option option = this;
        if (option instanceof Some) {
            Some someValue = (Some)option;
            return someValue.value;
        }
        if (this instanceof None) {
            return null;
        }
        throw new IllegalArgumentException();
    }

    default public Stream<T> stream() {
        Option option = this;
        if (option instanceof Some) {
            Some someValue = (Some)option;
            return Stream.of(someValue.value);
        }
        if (this instanceof None) {
            return Stream.empty();
        }
        throw new IllegalArgumentException();
    }

    @Override
    default public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    public record None<T>() implements Option<T>
    {
    }

    public record Some<T>(T value) implements Option<T>
    {
    }
}

