/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.unnecessary;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.CodeModel;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.MethodHierarchy;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.UsesFinder;
import java.util.Map;
import java.util.Optional;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

@ExecutableCheck(reportedProblems={ProblemType.UNUSED_CODE_ELEMENT, ProblemType.UNUSED_CODE_ELEMENT_PRIVATE})
public class UnusedCodeElementCheck
extends IntegratedCheck {
    public static boolean isConsideredUnused(CtNamedElement element, CodeModel model) {
        CtConstructor parentConstructor = SpoonUtil.getParentOrSelf((CtElement)element, CtConstructor.class);
        if (parentConstructor != null && SpoonUtil.isSubtypeOf(parentConstructor.getType(), Throwable.class)) {
            return false;
        }
        if (!model.hasMainMethod()) {
            CtTypeMember typeMember;
            CtElement ctElement;
            if (element instanceof CtParameter && (ctElement = element.getParent()) instanceof CtTypeMember && !(typeMember = (CtTypeMember)ctElement).getDeclaringType().isPrivate()) {
                return false;
            }
            if (element instanceof CtTypeMember && !(typeMember = (CtTypeMember)element).isPrivate() && !typeMember.getDeclaringType().isPrivate()) {
                return false;
            }
        }
        if (element instanceof CtVariable) {
            CtParameter parameter;
            CtExecutable ctExecutable;
            CtVariable variable = (CtVariable)element;
            if (UsesFinder.variableUses(variable).hasAny()) {
                return false;
            }
            if (variable instanceof CtParameter && (ctExecutable = (parameter = (CtParameter)variable).getParent()) instanceof CtMethod) {
                CtMethod method = (CtMethod)ctExecutable;
                int parameterIndex = SpoonUtil.getParameterIndex(parameter, method);
                return MethodHierarchy.streamAllOverridingMethods(method).allMatch(m -> UnusedCodeElementCheck.isConsideredUnused((CtNamedElement)m.getExecutable().getParameters().get(parameterIndex), model));
            }
            return true;
        }
        if (element instanceof CtTypeParameter) {
            CtTypeParameter typeParameter = (CtTypeParameter)element;
            return UsesFinder.typeParameterUses(typeParameter).hasNone();
        }
        if (element instanceof CtType) {
            CtType type = (CtType)element;
            return UsesFinder.typeUses(type).hasNone();
        }
        if (element instanceof CtExecutable) {
            CtExecutable executable = (CtExecutable)element;
            if (UsesFinder.executableUses(executable).filterIndirectParent(CtMethod.class, m -> m != executable).hasAny()) {
                return false;
            }
            if (executable instanceof CtMethod) {
                CtMethod method = (CtMethod)executable;
                return MethodHierarchy.streamAllOverridingMethods(method).allMatch(m -> UnusedCodeElementCheck.isConsideredUnused(m.getExecutable(), model));
            }
            return true;
        }
        throw new IllegalArgumentException("Unsupported element: " + element.getClass().getName());
    }

    private void checkUnused(CtNamedElement ctElement, CodeModel model) {
        if (ctElement.isImplicit() || !ctElement.getPosition().isValidPosition()) {
            return;
        }
        boolean unused = UnusedCodeElementCheck.isConsideredUnused(ctElement, model);
        if (unused) {
            CtModifiable ctModifiable;
            ProblemType problemType = ProblemType.UNUSED_CODE_ELEMENT;
            if (ctElement instanceof CtModifiable && (ctModifiable = (CtModifiable)ctElement).isPrivate()) {
                problemType = ProblemType.UNUSED_CODE_ELEMENT_PRIVATE;
            }
            String name = ctElement.getSimpleName();
            if (ctElement instanceof CtConstructor) {
                CtConstructor ctConstructor = (CtConstructor)ctElement;
                name = "%s()".formatted(ctConstructor.getDeclaringType().getSimpleName());
            }
            this.addLocalProblem((CtElement)ctElement, (Translatable)new LocalizedMessage("unused-element", Map.of("name", name)), problemType);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        final CodeModel model = staticAnalysis.getCodeModel();
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public <T> void visitCtLocalVariable(CtLocalVariable<T> ctLocalVariable) {
                UnusedCodeElementCheck.this.checkUnused((CtNamedElement)ctLocalVariable, model);
                super.visitCtLocalVariable(ctLocalVariable);
            }

            public <T> void visitCtMethod(CtMethod<T> ctMethod) {
                if (MethodHierarchy.isOverridingMethod(ctMethod) || SpoonUtil.isMainMethod(ctMethod)) {
                    super.visitCtMethod(ctMethod);
                    return;
                }
                UnusedCodeElementCheck.this.checkUnused((CtNamedElement)ctMethod, model);
                super.visitCtMethod(ctMethod);
            }

            public <T> void visitCtConstructor(CtConstructor<T> ctConstructor) {
                if (ctConstructor.isPrivate()) {
                    super.visitCtConstructor(ctConstructor);
                    return;
                }
                UnusedCodeElementCheck.this.checkUnused((CtNamedElement)ctConstructor, model);
                super.visitCtConstructor(ctConstructor);
            }

            public <T> void visitCtParameter(CtParameter<T> ctParameter) {
                if (SpoonUtil.isInOverridingMethod(ctParameter) || SpoonUtil.isInMainMethod(ctParameter) || ctParameter.getParent() instanceof CtLambda || ctParameter.getParent(CtInterface.class) != null) {
                    super.visitCtParameter(ctParameter);
                    return;
                }
                UnusedCodeElementCheck.this.checkUnused((CtNamedElement)ctParameter, model);
                super.visitCtParameter(ctParameter);
            }

            public void visitCtTypeParameter(CtTypeParameter ctTypeParameter) {
                UnusedCodeElementCheck.this.checkUnused((CtNamedElement)ctTypeParameter, model);
                super.visitCtTypeParameter(ctTypeParameter);
            }

            public <T> void visitCtField(CtField<T> ctField) {
                if (ctField.getSimpleName().equals("serialVersionUID")) {
                    super.visitCtField(ctField);
                    return;
                }
                UnusedCodeElementCheck.this.checkUnused((CtNamedElement)ctField, model);
                super.visitCtField(ctField);
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(6);
    }
}

