/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.structure;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;

@ExecutableCheck(reportedProblems={ProblemType.TOO_FEW_PACKAGES})
public class TooFewPackagesCheck
extends IntegratedCheck {
    public static final int MAX_CLASSES_PER_PACKAGE = 8;
    public static final String LOCALIZED_MESSAGE_KEY = "too-few-packages";

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        List<CtPackage> packages = staticAnalysis.getModel().getAllPackages().stream().filter(CtPackage::hasTypes).toList();
        if (packages.size() == 1 && packages.stream().anyMatch(ctPackage -> ctPackage.getTypes().size() > 8)) {
            Optional ctType = packages.get(0).getTypes().stream().findFirst();
            ctType.ifPresent(type -> this.addLocalProblem((CtElement)type, (Translatable)new LocalizedMessage(LOCALIZED_MESSAGE_KEY, Map.of("max", 8)), ProblemType.TOO_FEW_PACKAGES));
        }
    }
}

