/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.structure;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.UsesFinder;
import de.firemage.autograder.core.integrated.structure.StructuralElement;
import de.firemage.autograder.core.integrated.structure.StructuralEqualsVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spoon.processing.AbstractProcessor;
import spoon.processing.Processor;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

@ExecutableCheck(reportedProblems={ProblemType.DUPLICATE_CODE})
public class DuplicateCode
extends IntegratedCheck {
    private static final int MINIMUM_DUPLICATE_STATEMENT_SIZE = 10;

    private static String formatSourceRange(CtElement start, CtElement end) {
        SourcePosition startPosition = start.getPosition();
        SourcePosition endPosition = end.getPosition();
        return String.format("%s:%d-%d", SpoonUtil.getBaseName(startPosition.getFile().getName()), startPosition.getLine(), endPosition.getEndLine());
    }

    private static int countStatements(CtStatement ctStatement) {
        int count = ctStatement.getElements(ctElement -> ctElement instanceof CtStatement && !(ctElement instanceof CtComment) && !(ctElement instanceof CtStatementList) && ctElement.getPosition().isValidPosition() && !ctElement.isImplicit()).size();
        return Math.max(count, 1);
    }

    private static <K, V> Iterable<Map.Entry<K, V>> zip(final Iterable<K> keys, final Iterable<V> values) {
        return () -> new Iterator<Map.Entry<K, V>>(){
            private final Iterator<K> keyIterator;
            private final Iterator<V> valueIterator;
            {
                this.keyIterator = keys.iterator();
                this.valueIterator = values.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.keyIterator.hasNext() && this.valueIterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                return Map.entry(this.keyIterator.next(), this.valueIterator.next());
            }
        };
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        final HashMap occurrences = new HashMap();
        staticAnalysis.getModel().processWith((Processor)new AbstractProcessor<CtStatement>(){

            public void process(CtStatement ctStatement) {
                if (ctStatement.isImplicit() || !ctStatement.getPosition().isValidPosition()) {
                    return;
                }
                occurrences.computeIfAbsent(new StructuralElement<CtStatement>(ctStatement), key -> new ArrayList()).add(ctStatement);
            }
        });
        final HashSet reported = new HashSet();
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            private void checkCtStatement(CtStatement ctStatement) {
                if (ctStatement.isImplicit() || !ctStatement.getPosition().isValidPosition()) {
                    return;
                }
                List duplicates = (List)occurrences.get(new StructuralElement<CtStatement>(ctStatement));
                int initialSize = DuplicateCode.countStatements(ctStatement);
                for (CtStatement duplicate : duplicates) {
                    int numberOfUsedVariables;
                    int numberOfReassignedVariables;
                    if (duplicate == ctStatement || reported.contains(duplicate) || reported.contains(ctStatement)) continue;
                    int duplicateStatementSize = initialSize;
                    CodeSegment leftCode = CodeSegment.of(ctStatement);
                    CodeSegment rightCode = CodeSegment.of(duplicate);
                    for (Map.Entry<CtStatement, CtStatement> entry : DuplicateCode.zip(SpoonUtil.getNextStatements(ctStatement), SpoonUtil.getNextStatements(duplicate))) {
                        if (!StructuralEqualsVisitor.equals((CtElement)entry.getKey(), (CtElement)entry.getValue())) break;
                        leftCode.add(entry.getKey());
                        rightCode.add(entry.getValue());
                        duplicateStatementSize += DuplicateCode.countStatements(entry.getKey());
                    }
                    if (duplicateStatementSize < 10 || (numberOfReassignedVariables = leftCode.countDependencies(ctVariable -> !(ctVariable instanceof CtField) && !ctVariable.isStatic(), ctVariableAccess -> ctVariableAccess instanceof CtVariableWrite && ctVariableAccess.getParent() instanceof CtAssignment)) > 1 || numberOfReassignedVariables + (numberOfUsedVariables = Math.max(leftCode.countExposedVariables(), rightCode.countExposedVariables())) > 1) continue;
                    reported.addAll(leftCode.statements());
                    reported.addAll(rightCode.statements());
                    DuplicateCode.this.addLocalProblem((CtElement)ctStatement, new LocalizedMessage("duplicate-code", Map.of("left", DuplicateCode.formatSourceRange((CtElement)leftCode.getFirst(), (CtElement)leftCode.getLast()), "right", DuplicateCode.formatSourceRange((CtElement)rightCode.getFirst(), (CtElement)rightCode.getLast()))), ProblemType.DUPLICATE_CODE);
                    break;
                }
            }

            public <T> void visitCtMethod(CtMethod<T> ctMethod) {
                if (ctMethod.isImplicit() || !ctMethod.getPosition().isValidPosition() || ctMethod.getBody() == null) {
                    super.visitCtMethod(ctMethod);
                    return;
                }
                for (CtStatement ctStatement : SpoonUtil.getEffectiveStatements((CtStatement)ctMethod.getBody())) {
                    this.checkCtStatement(ctStatement);
                }
                super.visitCtMethod(ctMethod);
            }
        });
    }

    private record CodeSegment(List<CtStatement> statements) implements Iterable<CtStatement>
    {
        private final List<CtStatement> statements;

        public CodeSegment {
            statements = new ArrayList<CtStatement>(statements);
        }

        public static CodeSegment of(CtStatement ... statement) {
            return new CodeSegment(Arrays.asList(statement));
        }

        public void add(CtStatement ctStatement) {
            this.statements.add(ctStatement);
        }

        public CtStatement getFirst() {
            return this.statements.get(0);
        }

        public CtStatement getLast() {
            return this.statements.get(this.statements.size() - 1);
        }

        public List<CtStatement> statements() {
            return new ArrayList<CtStatement>(this.statements);
        }

        @Override
        public Iterator<CtStatement> iterator() {
            return this.statements().iterator();
        }

        private Set<CtVariable<?>> declaredVariables() {
            LinkedHashSet declaredVariables = new LinkedHashSet();
            for (CtStatement ctStatement : this) {
                if (!(ctStatement instanceof CtVariable)) continue;
                CtVariable ctVariable = (CtVariable)ctStatement;
                declaredVariables.add(ctVariable);
            }
            return declaredVariables;
        }

        public int countExposedVariables() {
            Set<CtVariable<?>> declaredVariables = this.declaredVariables();
            if (declaredVariables.isEmpty()) {
                return 0;
            }
            int count = 0;
            for (CtStatement ctStatement : SpoonUtil.getNextStatements(this.getLast())) {
                for (CtVariable<?> declaredVariable : declaredVariables) {
                    if (!UsesFinder.variableUses(declaredVariable).nestedIn((CtElement)ctStatement).hasAny()) continue;
                    ++count;
                }
            }
            return count;
        }

        public int countDependencies(Predicate<? super CtVariable<?>> isDependency, Predicate<? super CtVariableAccess<?>> isDependencyAccess) {
            if (this.statements().isEmpty()) {
                return 0;
            }
            Set codeSegmentVariables = this.statements.stream().flatMap(ctStatement -> ctStatement.getElements((Filter)new TypeFilter(CtVariable.class)).stream()).collect(Collectors.toCollection(() -> Collections.newSetFromMap(new IdentityHashMap())));
            return (int)((Stream)this.statements.stream().flatMap(ctStatement -> ctStatement.getElements((Filter)new TypeFilter(CtVariableAccess.class)).stream()).filter(isDependencyAccess).map(UsesFinder::getDeclaredVariable).unordered()).distinct().filter(ctVariable -> !codeSegmentVariables.contains(ctVariable) && isDependency.test((CtVariable<?>)ctVariable)).count();
        }
    }
}

