/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.structure;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;

@ExecutableCheck(reportedProblems={ProblemType.DEFAULT_PACKAGE_USED})
public class DefaultPackageCheck
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        CtPackage defaultPackage = staticAnalysis.getModel().getRootPackage();
        if (!defaultPackage.getQualifiedName().isEmpty()) {
            return;
        }
        ArrayList typesInDefaultPackage = new ArrayList(defaultPackage.getTypes());
        if (typesInDefaultPackage.isEmpty()) {
            return;
        }
        CtType ctType = (CtType)typesInDefaultPackage.get(0);
        String positions = typesInDefaultPackage.stream().map(CtElement::getPosition).map(SpoonUtil::formatSourcePosition).collect(Collectors.joining(", "));
        this.addLocalProblem((CtElement)ctType, (Translatable)new LocalizedMessage("default-package", Map.of("positions", positions)), ProblemType.DEFAULT_PACKAGE_USED);
    }
}

