/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtModifiable;

@ExecutableCheck(reportedProblems={ProblemType.UTILITY_CLASS_NOT_FINAL, ProblemType.UTILITY_CLASS_INVALID_CONSTRUCTOR})
public class UtilityClassCheck
extends IntegratedCheck {
    public static boolean isUtilityClass(CtClass<?> ctClass) {
        return ctClass.isClass() && !ctClass.isAnonymous() && !ctClass.getMethods().isEmpty() && ctClass.getMethods().stream().allMatch(CtModifiable::isStatic) && ctClass.getFields().stream().allMatch(CtModifiable::isStatic) && ctClass.getSuperclass() == null && ctClass.getSuperInterfaces().isEmpty() && !SpoonUtil.isInnerClass(ctClass);
    }

    private void checkCtClassConstructor(CtClass<?> ctClass, ProblemType problemType) {
        if (ctClass.getConstructors().stream().allMatch(CtElement::isImplicit)) {
            this.addLocalProblem((CtElement)ctClass, (Translatable)new LocalizedMessage("utility-exp-constructor"), problemType);
            return;
        }
        for (CtConstructor ctConstructor : ctClass.getConstructors()) {
            if (ctConstructor.isImplicit() || ctConstructor.isPrivate() || !ctConstructor.getParameters().isEmpty()) continue;
            this.addLocalProblem((CtElement)ctConstructor, (Translatable)new LocalizedMessage("utility-exp-constructor"), problemType);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtClass<?>>(){

            public void process(CtClass<?> ctClass) {
                if (!UtilityClassCheck.isUtilityClass(ctClass)) {
                    return;
                }
                if (ctClass.isAbstract()) {
                    UtilityClassCheck.this.checkCtClassConstructor(ctClass, ProblemType.UTILITY_CLASS_INVALID_CONSTRUCTOR);
                    return;
                }
                if (!ctClass.isFinal()) {
                    UtilityClassCheck.this.addLocalProblem(ctClass, new LocalizedMessage("utility-exp-final"), ProblemType.UTILITY_CLASS_NOT_FINAL);
                }
                UtilityClassCheck.this.checkCtClassConstructor(ctClass, ProblemType.UTILITY_CLASS_INVALID_CONSTRUCTOR);
            }
        });
    }
}

