/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.MethodHierarchy;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.visitor.Filter;

@ExecutableCheck(reportedProblems={ProblemType.METHOD_SHOULD_BE_STATIC, ProblemType.METHOD_SHOULD_BE_STATIC_NOT_PUBLIC})
public class MethodShouldBeStatic
extends IntegratedCheck {
    private static boolean isEffectivelyStatic(CtTypeMember ctTypeMember) {
        if (ctTypeMember.isStatic()) {
            return true;
        }
        if (ctTypeMember.getDeclaringType().isInterface() || ctTypeMember.isAbstract()) {
            return false;
        }
        if (ctTypeMember instanceof CtMethod) {
            CtMethod ctMethod = (CtMethod)ctTypeMember;
            if (MethodHierarchy.isOverridingMethod(ctMethod) || MethodHierarchy.isOverriddenMethod(ctMethod)) {
                return false;
            }
            if (ctMethod.getBody() == null) {
                return true;
            }
            return ctMethod.getBody().filterChildren((Filter)new ThisAccessFilter(ctTypeMember.getDeclaringType())).first() == null;
        }
        return false;
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtMethod<?>>(){

            public void process(CtMethod<?> ctMethod) {
                if (ctMethod.isImplicit() || !ctMethod.getPosition().isValidPosition()) {
                    return;
                }
                if (!ctMethod.isStatic() && MethodShouldBeStatic.isEffectivelyStatic(ctMethod)) {
                    MethodShouldBeStatic.this.addLocalProblem(ctMethod, new LocalizedMessage("method-should-be-static", Map.of("name", ctMethod.getSimpleName())), ctMethod.isPublic() ? ProblemType.METHOD_SHOULD_BE_STATIC : ProblemType.METHOD_SHOULD_BE_STATIC_NOT_PUBLIC);
                }
            }
        });
    }

    private record ThisAccessFilter(CtType<?> ctType) implements Filter<CtElement>
    {
        private boolean isSuperTypeAccess(CtTargetedExpression<?, ?> ctTargetedExpression) {
            CtSuperAccess superAccess;
            CtExpression ctExpression = ctTargetedExpression.getTarget();
            return ctExpression instanceof CtSuperAccess && this.ctType.isSubtypeOf((superAccess = (CtSuperAccess)ctExpression).getType());
        }

        private boolean isThisTypeAccess(CtTargetedExpression<?, ?> ctTargetedExpression) {
            CtTypeAccess ctTypeAccess;
            CtThisAccess thisAccess;
            if (this.isSuperTypeAccess(ctTargetedExpression)) {
                return true;
            }
            CtExpression ctExpression = ctTargetedExpression.getTarget();
            return ctExpression instanceof CtThisAccess && (ctExpression = (thisAccess = (CtThisAccess)ctExpression).getTarget()) instanceof CtTypeAccess && this.ctType.equals((Object)(ctTypeAccess = (CtTypeAccess)ctExpression).getAccessedType().getTypeDeclaration());
        }

        public boolean matches(CtElement element) {
            if (element instanceof CtFieldAccess) {
                CtFieldAccess ctFieldAccess = (CtFieldAccess)element;
                return this.isThisTypeAccess((CtTargetedExpression<?, ?>)ctFieldAccess);
            }
            if (element instanceof CtInvocation) {
                CtInvocation ctInvocation = (CtInvocation)element;
                return this.isThisTypeAccess((CtTargetedExpression<?, ?>)ctInvocation);
            }
            if (element instanceof CtExecutableReferenceExpression) {
                CtExecutableReferenceExpression ctExecutableReferenceExpression = (CtExecutableReferenceExpression)element;
                return this.isThisTypeAccess((CtTargetedExpression<?, ?>)ctExecutableReferenceExpression);
            }
            return false;
        }
    }
}

