/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.check.utils.Option;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.UsesFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtRecord;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

@ExecutableCheck(reportedProblems={ProblemType.LEAKED_COLLECTION_RETURN, ProblemType.LEAKED_COLLECTION_ASSIGN})
public class LeakedCollectionCheck
extends IntegratedCheck {
    private static boolean isMutableType(CtTypedElement<?> ctTypedElement) {
        return ctTypedElement.getType().isArray() || SpoonUtil.isSubtypeOf(ctTypedElement.getType(), Collection.class);
    }

    private static boolean canBeMutated(CtField<?> ctVariable) {
        if (ctVariable.getType().isArray()) {
            return true;
        }
        if (!SpoonUtil.isSubtypeOf(ctVariable.getType(), Collection.class)) {
            return false;
        }
        CtExpression defaultExpression = ctVariable.getDefaultExpression();
        if (defaultExpression != null && !defaultExpression.isImplicit() && LeakedCollectionCheck.isMutableExpression(defaultExpression)) {
            return true;
        }
        return UsesFinder.variableWrites(ctVariable).hasAnyMatch(ctFieldWrite -> {
            CtAssignment ctAssignment;
            CtElement patt4655$temp = ctFieldWrite.getParent();
            return patt4655$temp instanceof CtAssignment && LeakedCollectionCheck.isMutableExpression((ctAssignment = (CtAssignment)patt4655$temp).getAssignment());
        });
    }

    private static boolean isMutableExpression(CtExpression<?> ctExpression) {
        if (ctExpression instanceof CtNewArray) {
            return true;
        }
        if (!SpoonUtil.isSubtypeOf(ctExpression.getType(), Collection.class)) {
            return false;
        }
        if (ctExpression instanceof CtConstructorCall) {
            return true;
        }
        CtExecutable ctExecutable = (CtExecutable)ctExpression.getParent(CtExecutable.class);
        if (ctExpression instanceof CtVariableRead) {
            CtVariableRead ctVariableRead = (CtVariableRead)ctExpression;
            if (ctExecutable != null) {
                CtConstructor ctConstructor;
                CtType ctType;
                CtVariable<?> ctVariable = SpoonUtil.getVariableDeclaration(ctVariableRead.getVariable());
                if (ctExecutable instanceof CtConstructor && (ctType = (ctConstructor = (CtConstructor)ctExecutable).getDeclaringType()) instanceof CtEnum) {
                    CtEnum ctEnum = (CtEnum)ctType;
                    if (LeakedCollectionCheck.hasAssignedParameterReference(ctExpression, ctConstructor)) {
                        CtParameter<?> ctParameterToFind = LeakedCollectionCheck.findParameterReference(ctExpression, ctConstructor).unwrap();
                        int index = -1;
                        for (CtParameter ctParameter : ctConstructor.getParameters()) {
                            ++index;
                            if (ctParameter != ctParameterToFind) continue;
                            break;
                        }
                        if (index >= ctConstructor.getParameters().size() || index == -1) {
                            throw new IllegalStateException("Could not find parameter reference of %s in %s".formatted(ctExpression, ctConstructor));
                        }
                        for (CtEnumValue ctEnumValue : ctEnum.getEnumValues()) {
                            CtConstructorCall ctConstructorCall;
                            CtExpression ctExpression2 = ctEnumValue.getDefaultExpression();
                            if (!(ctExpression2 instanceof CtConstructorCall) || (ctConstructorCall = (CtConstructorCall)ctExpression2).getExecutable().getExecutableDeclaration() != ctConstructor || !LeakedCollectionCheck.isMutableExpression((CtExpression)ctConstructorCall.getArguments().get(index))) continue;
                            return true;
                        }
                        return false;
                    }
                }
                if (LeakedCollectionCheck.hasAssignedParameterReference(ctVariableRead, ctExecutable) || ctVariable.getDefaultExpression() != null && LeakedCollectionCheck.isMutableExpression(ctVariable.getDefaultExpression())) {
                    return true;
                }
                return UsesFinder.variableWrites(ctVariable).hasAnyMatch(ctVariableWrite -> {
                    CtAssignment ctAssignment;
                    CtElement patt8435$temp = ctVariableWrite.getParent();
                    return patt8435$temp instanceof CtAssignment && LeakedCollectionCheck.isMutableExpression((ctAssignment = (CtAssignment)patt8435$temp).getAssignment());
                });
            }
        }
        return false;
    }

    private static boolean isParameterOf(CtVariable<?> ctVariable, CtExecutable<?> ctExecutable) {
        return ctExecutable.getParameters().stream().anyMatch(ctParameter -> ctParameter == ctVariable);
    }

    private static List<CtExpression<?>> findPreviousAssignee(CtVariableRead<?> ctVariableRead) {
        ArrayList result = new ArrayList();
        CtExecutable ctExecutable = (CtExecutable)ctVariableRead.getParent(CtExecutable.class);
        boolean foundPreviousAssignment = false;
        CtStatement currentStatement = (CtStatement)ctVariableRead.getParent(CtStatement.class);
        ArrayList<CtStatement> reversedStatements = new ArrayList<CtStatement>(SpoonUtil.getEffectiveStatements((CtStatement)ctExecutable.getBody()));
        Collections.reverse(reversedStatements);
        for (CtStatement ctStatement : reversedStatements) {
            CtVariableWrite ctVariableWrite;
            CtAssignment ctAssignment;
            CtExpression ctExpression;
            if (!foundPreviousAssignment) {
                if (ctStatement != currentStatement) continue;
                foundPreviousAssignment = true;
                continue;
            }
            if (!(ctStatement instanceof CtAssignment) || !((ctExpression = (ctAssignment = (CtAssignment)ctStatement).getAssigned()) instanceof CtVariableWrite) || !(ctVariableWrite = (CtVariableWrite)ctExpression).getVariable().equals(ctVariableRead.getVariable())) continue;
            result.add(ctAssignment.getAssignment());
        }
        return result;
    }

    private static Option<CtParameter<?>> findParameterReference(CtExpression<?> ctExpression, CtExecutable<?> ctExecutable) {
        if (!(ctExpression instanceof CtVariableRead)) {
            return Option.none();
        }
        CtVariableRead ctVariableRead = (CtVariableRead)ctExpression;
        CtVariable<?> ctVariableDeclaration = SpoonUtil.getVariableDeclaration(ctVariableRead.getVariable());
        if (ctVariableDeclaration != null && LeakedCollectionCheck.isParameterOf(ctVariableDeclaration, ctExecutable)) {
            List<CtExpression<?>> previousAssignees = LeakedCollectionCheck.findPreviousAssignee(ctVariableRead);
            if (!previousAssignees.isEmpty()) {
                return LeakedCollectionCheck.findParameterReference(previousAssignees.get(0), ctExecutable);
            }
            return Option.some((CtParameter)ctVariableDeclaration);
        }
        return Option.none();
    }

    private static boolean hasAssignedParameterReference(CtExpression<?> ctExpression, CtExecutable<?> ctExecutable) {
        return LeakedCollectionCheck.findParameterReference(ctExpression, ctExecutable).isSome();
    }

    private void checkCtExecutableReturn(CtExecutable<?> ctExecutable) {
        CtModifiable ctModifiable;
        List<CtStatement> statements = SpoonUtil.getEffectiveStatements((CtStatement)ctExecutable.getBody());
        if (statements.isEmpty() && ctExecutable instanceof CtLambda) {
            CtLambda ctLambda = (CtLambda)ctExecutable;
            statements = List.of(LeakedCollectionCheck.createCtReturn(ctLambda.getExpression().clone()));
        }
        if (statements.isEmpty() || ctExecutable instanceof CtModifiable && (ctModifiable = (CtModifiable)ctExecutable).isPrivate()) {
            return;
        }
        List returns = statements.stream().flatMap(ctStatement -> {
            if (ctStatement instanceof CtReturn) {
                CtReturn ctReturn = (CtReturn)ctStatement;
                return List.of(ctReturn).stream();
            }
            return ctStatement.filterChildren((Filter)new TypeFilter(CtReturn.class)).list(CtReturn.class).stream();
        }).toList();
        for (CtReturn ctReturn : returns) {
            CtFieldRead ctFieldRead;
            CtField field;
            CtExpression returnedExpression = ctReturn.getReturnedExpression();
            if (!(returnedExpression instanceof CtFieldRead) || (field = (ctFieldRead = (CtFieldRead)returnedExpression).getVariable().getFieldDeclaration()) == null || !field.isPrivate() || !LeakedCollectionCheck.canBeMutated(field)) continue;
            this.addLocalProblem(SpoonUtil.findValidPosition(ctExecutable), (Translatable)new LocalizedMessage("leaked-collection-return", Map.of("method", ctExecutable.getSimpleName(), "field", field.getSimpleName())), ProblemType.LEAKED_COLLECTION_RETURN);
        }
    }

    private static String formatSignature(CtExecutable<?> ctExecutable) {
        String name = ctExecutable.getSimpleName();
        if (ctExecutable instanceof CtConstructor) {
            CtConstructor ctConstructor = (CtConstructor)ctExecutable;
            name = ctConstructor.getType().getSimpleName();
        }
        return "%s(%s)".formatted(name, ctExecutable.getParameters().stream().map(CtTypedElement::getType).map(Object::toString).collect(Collectors.joining(", ")));
    }

    private void checkCtExecutableAssign(CtExecutable<?> ctExecutable) {
        CtModifiable ctModifiable;
        if (ctExecutable instanceof CtModifiable && (ctModifiable = (CtModifiable)ctExecutable).isPrivate()) {
            return;
        }
        for (CtStatement ctStatement : SpoonUtil.getEffectiveStatements((CtStatement)ctExecutable.getBody())) {
            CtAssignment ctAssignment;
            CtExpression ctExpression;
            if (!(ctStatement instanceof CtAssignment) || !((ctExpression = (ctAssignment = (CtAssignment)ctStatement).getAssigned()) instanceof CtFieldWrite)) continue;
            CtFieldWrite ctFieldWrite = (CtFieldWrite)ctExpression;
            CtField ctField = ctFieldWrite.getVariable().getFieldDeclaration();
            if (!LeakedCollectionCheck.hasAssignedParameterReference(ctAssignment.getAssignment(), ctExecutable) || !ctField.isPrivate() || !LeakedCollectionCheck.isMutableType(ctField)) continue;
            if (ctExecutable instanceof CtConstructor) {
                CtConstructor ctConstructor = (CtConstructor)ctExecutable;
                this.addLocalProblem(SpoonUtil.findValidPosition((CtElement)ctStatement), (Translatable)new LocalizedMessage("leaked-collection-constructor", Map.of("signature", LeakedCollectionCheck.formatSignature(ctConstructor), "field", ctFieldWrite.getVariable().getSimpleName())), ProblemType.LEAKED_COLLECTION_ASSIGN);
                continue;
            }
            this.addLocalProblem(SpoonUtil.findValidPosition((CtElement)ctStatement), (Translatable)new LocalizedMessage("leaked-collection-assign", Map.of("method", ctExecutable.getSimpleName(), "field", ctFieldWrite.getVariable().getSimpleName())), ProblemType.LEAKED_COLLECTION_ASSIGN);
        }
    }

    private static CtReturn<?> createCtReturn(CtExpression<?> ctExpression) {
        CtReturn ctReturn = ctExpression.getFactory().createReturn();
        return ctReturn.setReturnedExpression(ctExpression);
    }

    private static CtMethod<?> fixRecordAccessor(CtRecord ctRecord, CtMethod<?> ctMethod) {
        Factory factory = ctMethod.getFactory();
        CtMethod result = ctMethod.clone();
        CtFieldRead ctFieldRead = factory.createFieldRead();
        ctFieldRead.setTarget(null);
        ctFieldRead.setVariable((CtVariableReference)ctRecord.getField(ctMethod.getSimpleName()).getReference());
        ctFieldRead.setType(result.getType());
        result.setBody(LeakedCollectionCheck.createCtReturn(ctFieldRead));
        result.setParent((CtElement)ctRecord);
        return result;
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            private <T> void checkCtType(CtType<T> ctType) {
                if (ctType.isImplicit() || !ctType.getPosition().isValidPosition()) {
                    return;
                }
                for (CtMethod<?> ctTypeMember : ctType.getTypeMembers()) {
                    CtMethod ctMethod;
                    if (ctType instanceof CtRecord) {
                        CtRecord ctRecord = (CtRecord)ctType;
                        if (ctTypeMember instanceof CtMethod && (ctMethod = (CtMethod)ctTypeMember).isImplicit()) {
                            ctTypeMember = LeakedCollectionCheck.fixRecordAccessor(ctRecord, ctMethod);
                        }
                    }
                    if (ctTypeMember instanceof CtConstructor) {
                        CtConstructor ctConstructor = (CtConstructor)ctTypeMember;
                        LeakedCollectionCheck.this.checkCtExecutableAssign((CtExecutable<?>)ctConstructor);
                        continue;
                    }
                    if (!(ctTypeMember instanceof CtMethod)) continue;
                    ctMethod = (CtMethod)ctTypeMember;
                    LeakedCollectionCheck.this.checkCtExecutableReturn((CtExecutable<?>)ctMethod);
                    LeakedCollectionCheck.this.checkCtExecutableAssign((CtExecutable<?>)ctMethod);
                }
            }

            public <T> void visitCtClass(CtClass<T> ctClass) {
                this.checkCtType((CtType<T>)ctClass);
                super.visitCtClass(ctClass);
            }

            public <E extends Enum<?>> void visitCtEnum(CtEnum<E> ctEnum) {
                this.checkCtType((CtType)ctEnum);
                super.visitCtEnum(ctEnum);
            }

            public void visitCtRecord(CtRecord ctRecord) {
                this.checkCtType((CtType)ctRecord);
                super.visitCtRecord(ctRecord);
            }

            public <T> void visitCtLambda(CtLambda<T> ctLambda) {
                LeakedCollectionCheck.this.checkCtExecutableReturn((CtExecutable<?>)ctLambda);
                LeakedCollectionCheck.this.checkCtExecutableAssign((CtExecutable<?>)ctLambda);
                super.visitCtLambda(ctLambda);
            }

            public void visitCtAnonymousExecutable(CtAnonymousExecutable ctAnonymousExecutable) {
                LeakedCollectionCheck.this.checkCtExecutableReturn((CtExecutable<?>)ctAnonymousExecutable);
                LeakedCollectionCheck.this.checkCtExecutableAssign((CtExecutable<?>)ctAnonymousExecutable);
                super.visitCtAnonymousExecutable(ctAnonymousExecutable);
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(4);
    }
}

