/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Set;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtInterface;

@ExecutableCheck(reportedProblems={ProblemType.DO_NOT_HAVE_CONSTANTS_CLASS, ProblemType.EMPTY_INTERFACE})
public class InterfaceBadPractices
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtInterface<?>>(){

            public void process(CtInterface<?> ctInterface) {
                List fields = ctInterface.getFields();
                Set methods = ctInterface.getMethods();
                if (methods.isEmpty() && fields.isEmpty()) {
                    InterfaceBadPractices.this.addLocalProblem(ctInterface, new LocalizedMessage("empty-interface-exp"), ProblemType.EMPTY_INTERFACE);
                    return;
                }
                if (methods.isEmpty()) {
                    InterfaceBadPractices.this.addLocalProblem(ctInterface, new LocalizedMessage("constants-class-exp"), ProblemType.DO_NOT_HAVE_CONSTANTS_CLASS);
                }
            }
        });
    }
}

