/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Objects;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.DO_NOT_HAVE_CONSTANTS_CLASS})
public class DoNotMakeConstantsClasses
extends IntegratedCheck {
    private static final int FIELD_THRESHOLD = 12;

    private boolean isConstantsClassLike(CtType<?> ctType) {
        return !ctType.isAnonymous() && !ctType.getFields().isEmpty() && ctType.getFields().stream().allMatch(ctField -> ctField.isStatic() && SpoonUtil.isEffectivelyFinal(ctField)) && !ctType.isAbstract() && ctType.getSuperInterfaces().isEmpty() && ctType.getNestedTypes().isEmpty() && !SpoonUtil.isInnerClass(ctType);
    }

    private boolean isConstantsEnum(CtType<?> ctType) {
        CtEnum ctEnum;
        return ctType.isEnum() && ctType.getMethods().size() <= 3 && ctType instanceof CtEnum && !(ctEnum = (CtEnum)ctType).getEnumValues().isEmpty() && ctEnum.getEnumValues().stream().map(ctEnumValue -> {
            CtExpression ctExpression = ctEnumValue.getDefaultExpression();
            if (ctExpression == null) {
                return null;
            }
            if (ctExpression instanceof CtConstructorCall) {
                CtConstructorCall ctConstructorCall = (CtConstructorCall)ctExpression;
                return ctConstructorCall;
            }
            return null;
        }).filter(Objects::nonNull).allMatch(ctConstructorCall -> {
            if (ctConstructorCall.getArguments().size() != 1) {
                return false;
            }
            CtTypeReference ctTypeReference = ((CtExpression)ctConstructorCall.getArguments().get(0)).getType();
            return ctTypeReference != null && ctTypeReference.getQualifiedName().equals("java.lang.String");
        }) && ctEnum.getEnumValues().size() > 12;
    }

    private boolean isConstantsClass(CtType<?> ctType) {
        int fieldCount = (int)ctType.getFields().stream().filter(ctField -> !ctField.isPrivate()).count();
        return ctType.isClass() && ctType.getSuperclass() == null && this.isConstantsClassLike(ctType) && (ctType.getMethods().isEmpty() && fieldCount > 1 || fieldCount > 12);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtType<?>>(){

            public void process(CtType<?> ctType) {
                if (DoNotMakeConstantsClasses.this.isConstantsClass(ctType) || DoNotMakeConstantsClasses.this.isConstantsEnum(ctType)) {
                    DoNotMakeConstantsClasses.this.addLocalProblem(ctType, new LocalizedMessage("constants-class-exp"), ProblemType.DO_NOT_HAVE_CONSTANTS_CLASS);
                }
            }
        });
    }
}

