/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.effects.AssignmentEffect;
import de.firemage.autograder.core.integrated.effects.Effect;
import de.firemage.autograder.core.integrated.effects.TerminalEffect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import spoon.reflect.code.CtAbstractSwitch;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

@ExecutableCheck(reportedProblems={ProblemType.CLOSED_SET_OF_VALUES})
public class ClosedSetOfValues
extends IntegratedCheck {
    private static final int MIN_SET_SIZE = 3;
    private static final int MAX_SET_SIZE = 12;
    private static final List<Class<?>> SUPPORTED_TYPES = List.of(String.class, Character.class, Character.TYPE);

    private static boolean isSupportedType(CtTypeReference<?> ctTypeReference) {
        return SpoonUtil.isTypeEqualTo(ctTypeReference, SUPPORTED_TYPES.toArray(new Class[0]));
    }

    private boolean shouldSwitchOverEnum(CtAbstractSwitch<?> ctSwitch) {
        for (CtCase ctCase : ctSwitch.getCases()) {
            Effect effect;
            if (ctCase.getCaseExpressions().isEmpty() || (effect = (Effect)SpoonUtil.getSingleEffect(ctCase.getStatements()).orElse(null)) instanceof TerminalEffect || effect instanceof AssignmentEffect) continue;
            return true;
        }
        return false;
    }

    private static Set<CtLiteral<?>> getDistinctElementsFromSwitch(CtAbstractSwitch<?> ctSwitch) {
        List<CtExpression> elements = ctSwitch.getCases().stream().flatMap(e -> e.getCaseExpressions().stream()).map(SpoonUtil::resolveCtExpression).toList();
        if (elements.stream().anyMatch(e -> !(e instanceof CtLiteral))) {
            return Set.of();
        }
        return ClosedSetOfValues.distinctElements(elements);
    }

    private void checkSwitch(CtAbstractSwitch<?> ctSwitch) {
        CtTypeReference ctTypeReference = ctSwitch.getSelector().getType();
        if (!ClosedSetOfValues.isSupportedType(ctTypeReference)) {
            return;
        }
        Set<CtLiteral<?>> distinctElements = ClosedSetOfValues.getDistinctElementsFromSwitch(ctSwitch);
        if (distinctElements.size() < 3 || distinctElements.size() > 12) {
            return;
        }
        if (this.shouldSwitchOverEnum(ctSwitch)) {
            this.addLocalProblem((CtElement)ctSwitch, (Translatable)new LocalizedMessage("closed-set-of-values-switch", Map.of("values", distinctElements.stream().map(Object::toString).collect(Collectors.joining(", ")))), ProblemType.CLOSED_SET_OF_VALUES);
        }
    }

    private static Set<CtLiteral<?>> distinctElements(Collection<? extends CtLiteral<?>> elements) {
        return new LinkedHashSet(elements.stream().filter(e -> e.getValue() != null).toList());
    }

    private static boolean isFiniteSet(Collection<? extends CtLiteral<?>> distinctElements) {
        return distinctElements.size() >= 3 && distinctElements.size() <= 12;
    }

    private static List<CtLiteral<?>> getFiniteSet(Iterable<? extends CtExpression<?>> elements) {
        ArrayList result = new ArrayList();
        for (CtExpression<?> ctExpression : elements) {
            CtExpression<?> resolved = SpoonUtil.resolveCtExpression(ctExpression);
            if (!ClosedSetOfValues.isSupportedType(resolved.getType()) || !(resolved instanceof CtLiteral)) {
                return List.of();
            }
            CtLiteral ctLiteral = (CtLiteral)resolved;
            result.add(ctLiteral);
        }
        return result;
    }

    private void checkFiniteListing(CtExpression<?> ctExpression, Iterable<? extends CtExpression<?>> values) {
        List<CtLiteral<?>> literals = ClosedSetOfValues.getFiniteSet(values);
        Set<CtLiteral<?>> distinctElements = ClosedSetOfValues.distinctElements(literals);
        if (literals.isEmpty() || !ClosedSetOfValues.isFiniteSet(distinctElements)) {
            return;
        }
        this.addLocalProblem((CtElement)ctExpression, (Translatable)new LocalizedMessage("closed-set-of-values-list", Map.of("values", distinctElements.stream().map(Object::toString).collect(Collectors.joining(", ")))), ProblemType.CLOSED_SET_OF_VALUES);
    }

    private void checkCtMethod(CtMethod<?> ctMethod) {
        CtTypeReference returnType = ctMethod.getType();
        if (returnType == null || !ClosedSetOfValues.isSupportedType(returnType)) {
            return;
        }
        List ctReturns = ctMethod.getElements((Filter)new TypeFilter(CtReturn.class));
        List<CtLiteral<?>> literals = ClosedSetOfValues.getFiniteSet(ctReturns.stream().map(CtReturn::getReturnedExpression).toList());
        Set<CtLiteral<?>> distinctElements = ClosedSetOfValues.distinctElements(literals);
        if (literals.isEmpty() || !ClosedSetOfValues.isFiniteSet(distinctElements)) {
            return;
        }
        this.addLocalProblem((CtElement)ctMethod, (Translatable)new LocalizedMessage("closed-set-of-values-method", Map.of("values", distinctElements.stream().map(Object::toString).collect(Collectors.joining(", ")))), ProblemType.CLOSED_SET_OF_VALUES);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
                ClosedSetOfValues.this.checkSwitch((CtAbstractSwitch<?>)switchStatement);
                super.visitCtSwitch(switchStatement);
            }

            public <T, S> void visitCtSwitchExpression(CtSwitchExpression<T, S> switchExpression) {
                ClosedSetOfValues.this.checkSwitch((CtAbstractSwitch<?>)switchExpression);
                super.visitCtSwitchExpression(switchExpression);
            }

            public <T> void visitCtField(CtField<T> ctField) {
                CtExpression ctExpression = ctField.getDefaultExpression();
                if (ctExpression == null) {
                    return;
                }
                if (ctExpression.isImplicit()) {
                    return;
                }
                if (!SpoonUtil.isEffectivelyFinal(ctField)) {
                    return;
                }
                if (ctField.getType().isArray() && ctExpression instanceof CtNewArray) {
                    CtNewArray ctNewArray = (CtNewArray)ctExpression;
                    ClosedSetOfValues.this.checkFiniteListing(ctExpression, ctNewArray.getElements());
                } else {
                    ClosedSetOfValues.this.checkFiniteListing(ctExpression, SpoonUtil.getElementsOfExpression(ctExpression));
                }
                super.visitCtField(ctField);
            }

            public <T> void visitCtLocalVariable(CtLocalVariable<T> ctLocalVariable) {
                CtExpression ctExpression = ctLocalVariable.getDefaultExpression();
                if (ctExpression == null) {
                    return;
                }
                if (ctExpression.isImplicit()) {
                    return;
                }
                if (!SpoonUtil.isEffectivelyFinal(ctLocalVariable)) {
                    return;
                }
                if (ctLocalVariable.getType().isArray() && ctExpression instanceof CtNewArray) {
                    CtNewArray ctNewArray = (CtNewArray)ctExpression;
                    ClosedSetOfValues.this.checkFiniteListing(ctExpression, ctNewArray.getElements());
                } else {
                    ClosedSetOfValues.this.checkFiniteListing(ctExpression, SpoonUtil.getElementsOfExpression(ctExpression));
                }
                super.visitCtLocalVariable(ctLocalVariable);
            }

            public <T> void visitCtMethod(CtMethod<T> ctMethod) {
                ClosedSetOfValues.this.checkCtMethod(ctMethod);
                super.visitCtMethod(ctMethod);
            }
        });
    }
}

