/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.naming;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackageDeclaration;

@ExecutableCheck(reportedProblems={ProblemType.PACKAGE_NAMING_CONVENTION})
public class PackageNamingConvention
extends IntegratedCheck {
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile("[a-z][a-z0-9_]*");

    private static <T> Set<T> intersection(Set<? extends T> left, Collection<T> right) {
        HashSet<T> result = new HashSet<T>(left);
        result.retainAll(right);
        return result;
    }

    private void visitCtPackageDeclaration(StaticAnalysis staticAnalysis, Consumer<? super CtPackageDeclaration> lambda) {
        staticAnalysis.getModel().getAllTypes().stream().map(CtElement::getPosition).filter(SourcePosition::isValidPosition).map(SourcePosition::getCompilationUnit).map(CtCompilationUnit::getPackageDeclaration).forEach(lambda);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        LinkedHashSet invalidDeclarations = new LinkedHashSet();
        HashSet markedPackages = new HashSet();
        this.visitCtPackageDeclaration(staticAnalysis, ctPackageDeclaration -> {
            if (ctPackageDeclaration.isImplicit() || !ctPackageDeclaration.getPosition().isValidPosition() || ctPackageDeclaration.getReference() == null) {
                return;
            }
            String packageName = ctPackageDeclaration.getReference().getQualifiedName();
            Set invalidParts = Arrays.stream(packageName.split("\\.", -1)).filter(name -> !PACKAGE_NAME_PATTERN.matcher((CharSequence)name).matches()).collect(Collectors.toSet());
            if (invalidParts.isEmpty() || !PackageNamingConvention.intersection(invalidParts, markedPackages).isEmpty()) {
                return;
            }
            markedPackages.addAll(invalidParts);
            invalidDeclarations.add(ctPackageDeclaration);
        });
        ArrayList declarations = new ArrayList(invalidDeclarations);
        if (declarations.isEmpty()) {
            return;
        }
        CtPackageDeclaration ctPackageDeclaration2 = (CtPackageDeclaration)declarations.get(0);
        String positions = declarations.stream().map(CtElement::getPosition).map(SpoonUtil::formatSourcePosition).collect(Collectors.joining(", "));
        this.addLocalProblem((CtElement)ctPackageDeclaration2, (Translatable)new LocalizedMessage("package-naming-convention", Map.of("positions", positions)), ProblemType.PACKAGE_NAMING_CONVENTION);
    }
}

