/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.naming;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtField;

@ExecutableCheck(reportedProblems={ProblemType.MEANINGLESS_CONSTANT_NAME, ProblemType.CONSTANT_NAME_CONTAINS_VALUE})
public class ConstantsHaveDescriptiveNamesCheck
extends IntegratedCheck {
    private static final List<String> NUMBER_PRE_SUFFIXES = List.of("index", "number", "value", "argument", "element", "param", "parameter", "arg", "group", "constant", "value_of");
    private static final List<String> NON_DESCRIPTIVE_NAMES = List.of("error", "pattern", "regex", "symbol", "constant", "const", "compare", "linebreak");
    private static final Map<String, List<String>> SPECIAL_VALUE_MAPPING = Map.ofEntries(Map.entry("->", List.of("arrow")), Map.entry("-->", List.of("arrow")));
    private static final List<String> CONTEXTUAL_WORDS = List.of("space", "whitespace", "white_space", "empty", "blank");
    private static final double CONTEXTUAL_WORD_THRESHOLD = 0.5;
    private static final int MAXIMUM_NAME_DIFFERENCE = 2;

    private static boolean isNonDescriptiveIntegerName(String name, int value) {
        if (NON_DESCRIPTIVE_NAMES.contains(name.toLowerCase())) {
            return true;
        }
        List valueNameOptions = switch (value) {
            case 0 -> List.of("zero", "null", "zeroth", "first");
            case -1 -> List.of("minusone", "minus_one", "negative_one", "negativone", "neg_one", "negone");
            case 1 -> List.of("one", "second");
            case 2 -> List.of("two", "third");
            case 3 -> List.of("three", "fourth");
            case 4 -> List.of("four", "fifth");
            case 5 -> List.of("five", "sixth");
            case 6 -> List.of("six", "seventh");
            case 7 -> List.of("seven", "eighth");
            case 8 -> List.of("eight", "ninth");
            case 9 -> List.of("nine", "tenth");
            default -> List.of();
        };
        return valueNameOptions.stream().flatMap(o -> Stream.concat(Stream.of(o), NUMBER_PRE_SUFFIXES.stream().flatMap(s -> Stream.of(s + "_" + o, o + "_" + s)))).anyMatch(o -> name.toLowerCase().equals(o));
    }

    private static boolean isNonDescriptiveStringName(String name, String value) {
        String cleanedName = name.toLowerCase().replace("_", "");
        if (NON_DESCRIPTIVE_NAMES.contains(cleanedName)) {
            return true;
        }
        List<Object> options = new ArrayList<String>();
        options.add("");
        if (value.isEmpty()) {
            options = List.of("empty", "blank");
        } else {
            if (value.length() < 2) {
                return false;
            }
            for (char c : value.toCharArray()) {
                List<String> charOptions = ConstantsHaveDescriptiveNamesCheck.listCharOptions(c);
                if (charOptions == null) {
                    return false;
                }
                if (!(options = options.stream().flatMap(suffix -> charOptions.stream().map(o -> suffix + o)).filter(cleanedName::startsWith).toList()).isEmpty()) continue;
                return false;
            }
        }
        return options.contains(cleanedName);
    }

    private static List<String> listCharOptions(char c) {
        return switch (c) {
            case ' ' -> List.of("space", "whitespace", "white_space", "empty", "blank");
            case ',' -> List.of("comma", "punctuation");
            case '.' -> List.of("point", "dot", "fullstop", "full_stop", "punctuation");
            case '-' -> List.of("minus", "hyphen", "dash", "line");
            case ':' -> List.of("colon");
            case ';' -> List.of("semi_colon", "semicolon");
            case '_' -> List.of("underscore", "dash", "line");
            case '/', '\\' -> List.of("slash", "backslash");
            case '[', ']' -> List.of("bracket");
            default -> Character.isAlphabetic(c) ? List.of(String.valueOf(Character.toLowerCase(c))) : null;
        };
    }

    private static boolean containsValueInName(String name, CtLiteral<?> value) {
        Object charOptions;
        String lowerCaseName = name.toLowerCase();
        String valueString = "null";
        if (value.getValue() != null) {
            valueString = value.getValue().toString().toLowerCase();
        }
        if (valueString.isEmpty()) {
            return false;
        }
        if (valueString.length() == 1 && Character.isAlphabetic(valueString.charAt(0))) {
            String c = String.valueOf(valueString.charAt(0));
            return lowerCaseName.startsWith(c + "_") || lowerCaseName.endsWith("_" + c) || lowerCaseName.contains("_" + c + "_");
        }
        if (valueString.length() == 1 && !Character.isAlphabetic(valueString.charAt(0)) && (charOptions = ConstantsHaveDescriptiveNamesCheck.listCharOptions(valueString.charAt(0))) != null) {
            Iterator iterator = charOptions.iterator();
            while (iterator.hasNext()) {
                String option = (String)iterator.next();
                for (String word : name.split("_")) {
                    if (CONTEXTUAL_WORDS.contains(word = word.toLowerCase()) && (double)word.length() * 1.0 / ((double)lowerCaseName.length() * 1.0) < 0.5) {
                        return false;
                    }
                    if (!word.equals(option)) continue;
                    return true;
                }
            }
            return false;
        }
        for (Map.Entry<String, List<String>> entry : SPECIAL_VALUE_MAPPING.entrySet()) {
            if (!valueString.contains(entry.getKey())) continue;
            return entry.getValue().stream().anyMatch(lowerCaseName::contains);
        }
        if (lowerCaseName.contains(valueString = valueString.replace('-', '_'))) {
            String newName = lowerCaseName.replace(valueString, "");
            return newName.length() <= 2;
        }
        return false;
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtField<?>>(){

            public void process(CtField<?> field) {
                String v2;
                Integer v1;
                CtLiteral<String> literal;
                if (field.isImplicit() || !field.getPosition().isValidPosition()) {
                    return;
                }
                if (!field.isFinal() || field.getDefaultExpression() == null) {
                    return;
                }
                CtExpression ctExpression = field.getDefaultExpression();
                if (ctExpression instanceof CtLiteral) {
                    CtLiteral<String> ctLiteral;
                    literal = ctLiteral = (CtLiteral<String>)ctExpression;
                } else {
                    CtTypeAccess ctTypeAccess;
                    CtInvocation ctInvocation;
                    ctExpression = field.getDefaultExpression();
                    if (ctExpression instanceof CtInvocation && (ctExpression = (ctInvocation = (CtInvocation)ctExpression).getTarget()) instanceof CtTypeAccess && SpoonUtil.isTypeEqualTo((ctTypeAccess = (CtTypeAccess)ctExpression).getAccessedType(), System.class) && SpoonUtil.isSignatureEqualTo(ctInvocation.getExecutable(), String.class, "lineSeparator", new Class[0])) {
                        literal = SpoonUtil.makeLiteral(field.getFactory().Type().stringType(), "\n");
                    } else {
                        return;
                    }
                }
                String fieldName = field.getSimpleName();
                Object object = literal.getValue();
                if (object instanceof Integer && ConstantsHaveDescriptiveNamesCheck.isNonDescriptiveIntegerName(fieldName, v1 = (Integer)object) || (object = literal.getValue()) instanceof String && ConstantsHaveDescriptiveNamesCheck.isNonDescriptiveStringName(fieldName, v2 = (String)object)) {
                    ConstantsHaveDescriptiveNamesCheck.this.addLocalProblem(field, new LocalizedMessage("constants-name-exp", Map.of("name", field.getSimpleName(), "value", field.getDefaultExpression())), ProblemType.MEANINGLESS_CONSTANT_NAME);
                } else if (ConstantsHaveDescriptiveNamesCheck.containsValueInName(fieldName, literal)) {
                    ConstantsHaveDescriptiveNamesCheck.this.addLocalProblem(field, new LocalizedMessage("constants-name-exp-value", Map.of("name", field.getSimpleName(), "value", field.getDefaultExpression())), ProblemType.CONSTANT_NAME_CONTAINS_VALUE);
                }
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(6);
    }
}

