/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.MethodHierarchy;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.UsesFinder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import spoon.processing.AbstractProcessor;
import spoon.reflect.CtModel;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;

@ExecutableCheck(reportedProblems={ProblemType.USE_DIFFERENT_VISIBILITY, ProblemType.USE_DIFFERENT_VISIBILITY_PEDANTIC, ProblemType.USE_DIFFERENT_VISIBILITY_PUBLIC_FIELD})
public class UseDifferentVisibility
extends IntegratedCheck {
    private static Visibility getVisibility(CtTypeMember ctTypeMember) {
        CtPackage ctPackage;
        CtType ctType;
        CtModel ctModel = ctTypeMember.getFactory().getModel();
        Stream<Object> referencesStream = UsesFinder.getAllUses((CtNamedElement)ctTypeMember);
        if (ctTypeMember instanceof CtMethod) {
            CtMethod method = (CtMethod)ctTypeMember;
            referencesStream = Stream.concat(referencesStream, MethodHierarchy.streamAllOverridingMethods(method).map(MethodHierarchy.MethodOrLambda::getExecutable));
        }
        List references = referencesStream.toList();
        CtElement commonParent = SpoonUtil.findCommonParent((CtElement)ctTypeMember, references);
        CtType declaringType = ctTypeMember.getDeclaringType();
        if (ctTypeMember == commonParent) {
            return Visibility.of((CtModifiable)ctTypeMember);
        }
        if (commonParent instanceof CtType && ((ctType = (CtType)commonParent).equals(declaringType) || ctTypeMember.getTopLevelType().equals(ctType))) {
            return Visibility.PRIVATE;
        }
        if (commonParent instanceof CtPackage && (ctPackage = (CtPackage)commonParent).equals(ctModel.getRootPackage())) {
            if (((CtPackage)ctTypeMember.getParent(CtPackage.class)).equals(ctPackage) && references.stream().allMatch(ref -> ((CtPackage)ref.getParent(CtPackage.class)).equals(ctPackage))) {
                return Visibility.DEFAULT;
            }
            return Visibility.PUBLIC;
        }
        return Visibility.of((CtModifiable)ctTypeMember);
    }

    @Override
    protected void check(final StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtTypeMember>(){

            public void process(CtTypeMember ctTypeMember) {
                Visibility visibility;
                CtMethod ctMethod;
                if (!ctTypeMember.getPosition().isValidPosition() || ctTypeMember.isImplicit() || ctTypeMember.isPrivate()) {
                    return;
                }
                Visibility currentVisibility = Visibility.of((CtModifiable)ctTypeMember);
                if (ctTypeMember instanceof CtMethod && (SpoonUtil.isMainMethod(ctMethod = (CtMethod)ctTypeMember) || MethodHierarchy.isOverridingMethod(ctMethod))) {
                    return;
                }
                if (ctTypeMember instanceof CtEnumValue) {
                    return;
                }
                if (ctTypeMember instanceof CtMethod) {
                    CtMethod ctMethod2 = (CtMethod)ctTypeMember;
                    visibility = UseDifferentVisibility.getVisibility((CtTypeMember)ctMethod2);
                } else if (ctTypeMember instanceof CtField) {
                    CtField ctField = (CtField)ctTypeMember;
                    visibility = UseDifferentVisibility.getVisibility((CtTypeMember)ctField);
                    Optional<Visibility> referencingVisibility = ctField.getDeclaringType().getFields().stream().filter(field -> field != ctField && UsesFinder.variableUses(ctField).nestedIn((CtElement)field).hasAny()).map(UseDifferentVisibility::getVisibility).max(Enum::compareTo);
                    if (referencingVisibility.isPresent() && visibility.isMoreRestrictiveThan(referencingVisibility.get())) {
                        visibility = referencingVisibility.get();
                    }
                } else {
                    return;
                }
                if (visibility.isMoreRestrictiveThan(currentVisibility)) {
                    ProblemType problemType = ProblemType.USE_DIFFERENT_VISIBILITY_PEDANTIC;
                    if (visibility == Visibility.PRIVATE) {
                        problemType = ProblemType.USE_DIFFERENT_VISIBILITY;
                    }
                    if (!staticAnalysis.getCodeModel().hasMainMethod() && !ctTypeMember.getDeclaringType().isPrivate()) {
                        return;
                    }
                    UseDifferentVisibility.this.addLocalProblem((CtElement)ctTypeMember, new LocalizedMessage("use-different-visibility", Map.of("name", ctTypeMember.getSimpleName(), "suggestion", visibility.toString())), problemType);
                } else if (ctTypeMember instanceof CtField) {
                    CtField ctField = (CtField)ctTypeMember;
                    if (!(currentVisibility != Visibility.PUBLIC && currentVisibility != Visibility.DEFAULT || ctField.isStatic() && ctField.isFinal())) {
                        UseDifferentVisibility.this.addLocalProblem((CtElement)ctField, new LocalizedMessage("use-different-visibility-field", Map.of("name", ctField.getSimpleName(), "suggestion", Visibility.PRIVATE.toString())), ProblemType.USE_DIFFERENT_VISIBILITY_PUBLIC_FIELD);
                    }
                }
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(6);
    }

    private static enum Visibility implements Comparable<Visibility>
    {
        PRIVATE,
        DEFAULT,
        PROTECTED,
        PUBLIC;


        static Visibility of(CtModifiable ctModifiable) {
            if (ctModifiable.isPublic()) {
                return PUBLIC;
            }
            if (ctModifiable.isProtected()) {
                return PROTECTED;
            }
            if (ctModifiable.isPrivate()) {
                return PRIVATE;
            }
            return DEFAULT;
        }

        boolean isMoreRestrictiveThan(Visibility other) {
            return this.compareTo(other) < 0;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

