/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Scanner;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.SCANNER_MUST_BE_CLOSED})
public class ScannerClosedCheck
extends IntegratedCheck {
    @Override
    protected void check(final StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtConstructorCall<?>>(){

            public void process(CtConstructorCall<?> ctConstructorCall) {
                boolean isClosed;
                CtTypeReference ctTypeReference = ctConstructorCall.getType();
                if (ctTypeReference == null) {
                    return;
                }
                if (ctConstructorCall.isImplicit() || !ctConstructorCall.getPosition().isValidPosition()) {
                    return;
                }
                CtTypeReference scannerType = ctConstructorCall.getFactory().Type().createReference(Scanner.class);
                if (!ctTypeReference.equals(scannerType)) {
                    return;
                }
                boolean bl = isClosed = staticAnalysis.getModel().filterChildren(ctElement -> {
                    CtInvocation ctInvocation;
                    return ctElement instanceof CtInvocation && (ctInvocation = (CtInvocation)ctElement).getExecutable() != null && ctInvocation.getExecutable().getSimpleName().equals("close") && ctInvocation.getTarget() != null && scannerType.equals(ctInvocation.getTarget().getType());
                }).first() != null;
                if (!isClosed && ctConstructorCall.getParent(CtTryWithResource.class) == null) {
                    ScannerClosedCheck.this.addLocalProblem(ctConstructorCall, new LocalizedMessage("scanner-closed"), ProblemType.SCANNER_MUST_BE_CLOSED);
                }
            }
        });
    }
}

