/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.MethodHierarchy;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtMethod;

@ExecutableCheck(reportedProblems={ProblemType.OVERRIDE_ANNOTATION_MISSING})
public class OverrideAnnotationMissing
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtMethod<?>>(){

            public void process(CtMethod<?> ctMethod) {
                if (ctMethod.isImplicit() || !ctMethod.getPosition().isValidPosition() || ctMethod.hasAnnotation(Override.class)) {
                    return;
                }
                if (MethodHierarchy.isOverridingMethod(ctMethod)) {
                    OverrideAnnotationMissing.this.addLocalProblem(ctMethod, new LocalizedMessage("missing-override", Map.of("name", ctMethod.getSimpleName())), ProblemType.OVERRIDE_ANNOTATION_MISSING);
                }
            }
        });
    }
}

