/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.CompositeFilter;
import spoon.reflect.visitor.filter.FilteringOperator;
import spoon.reflect.visitor.filter.TypeFilter;

@ExecutableCheck(reportedProblems={ProblemType.MAGIC_STRING})
public class MagicString
extends IntegratedCheck {
    private static final Filter<CtLiteral<String>> IS_MAGIC_STRING = ctLiteral -> {
        if (((String)ctLiteral.getValue()).isEmpty()) {
            return false;
        }
        CtField parent = (CtField)ctLiteral.getParent(CtField.class);
        return parent == null || !parent.isStatic() || !parent.isFinal();
    };

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtType<?>>(){

            public void process(CtType<?> ctType) {
                if (ctType.isImplicit() || !ctType.getPosition().isValidPosition()) {
                    return;
                }
                List magicStrings = ctType.getElements((Filter)new CompositeFilter(FilteringOperator.INTERSECTION, new Filter[]{new TypeFilter(CtLiteral.class), element -> element.getType() != null && SpoonUtil.isTypeEqualTo(element.getType(), String.class), IS_MAGIC_STRING}));
                HashSet<String> reportedStrings = new HashSet<String>();
                for (CtLiteral magicString : magicStrings) {
                    if (!reportedStrings.add((String)magicString.getValue())) continue;
                    MagicString.this.addLocalProblem((CtElement)magicString, new LocalizedMessage("magic-string", Map.of("value", (String)magicString.getValue())), ProblemType.MAGIC_STRING);
                }
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(1);
    }
}

