/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.CodeModel;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.UsesFinder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtVariableReference;

@ExecutableCheck(reportedProblems={ProblemType.LOOP_SHOULD_BE_FOR})
public class LoopShouldBeFor
extends IntegratedCheck {
    private static CtFor createCtFor(Collection<? extends CtStatement> init, CtExpression<Boolean> condition, Collection<? extends CtStatement> forUpdate, CtStatement body) {
        CtFor ctFor = body.getFactory().Core().createFor();
        ctFor.setForInit(init.stream().map(CtStatement::clone).toList());
        if (condition != null) {
            ctFor.setExpression(condition.clone());
        }
        ctFor.setForUpdate(forUpdate.stream().map(CtStatement::clone).toList());
        ctFor.setBody(body.clone());
        return ctFor;
    }

    private static LoopSuggestion getCounter(CtLoop ctLoop, CodeModel model) {
        CtBlock newBody;
        CtUnaryOperator ctUnaryOperator;
        CtLocalVariable ctLocalVariable;
        List<CtStatement> statements = SpoonUtil.getEffectiveStatements(ctLoop.getBody());
        if (statements.isEmpty()) {
            return null;
        }
        CtStatement previous = SpoonUtil.getPreviousStatement((CtStatement)ctLoop).orElse(null);
        if (!(previous instanceof CtLocalVariable) || !SpoonUtil.isPrimitiveNumeric((ctLocalVariable = (CtLocalVariable)previous).getType())) {
            return null;
        }
        CtStatement lastStatement = null;
        for (int i = statements.size() - 1; i >= 0; --i) {
            CtVariableWrite ctWrite;
            CtVariableWrite ctVariableWrite;
            CtAssignment ctAssignment;
            CtExpression ctExpression;
            CtStatement statement2 = statements.get(i);
            if (statement2 instanceof CtAssignment && (ctExpression = (ctAssignment = (CtAssignment)statement2).getAssigned()) instanceof CtVariableWrite && (ctVariableWrite = (CtVariableWrite)ctExpression).getVariable().equals(ctLocalVariable.getReference()) || statement2 instanceof CtUnaryOperator && (ctExpression = (ctUnaryOperator = (CtUnaryOperator)statement2).getOperand()) instanceof CtVariableWrite && (ctWrite = (CtVariableWrite)ctExpression).getVariable().equals(ctLocalVariable.getReference())) {
                lastStatement = statement2;
                break;
            }
            if (!UsesFinder.variableUses(ctLocalVariable).nestedIn((CtElement)statement2).hasAny()) continue;
            return null;
        }
        if (lastStatement == null) {
            return null;
        }
        CtStatement finalLastStatement = lastStatement;
        boolean isUpdatedMultipleTimes = statements.stream().filter(statement -> statement != finalLastStatement).anyMatch(statement -> UsesFinder.variableUses(ctLocalVariable).ofType(CtVariableWrite.class).nestedIn((CtElement)statement).hasAny());
        if (isUpdatedMultipleTimes) {
            return null;
        }
        ctUnaryOperator = ctLoop.getBody();
        if (ctUnaryOperator instanceof CtBlock) {
            CtBlock block = (CtBlock)ctUnaryOperator;
            CtBlock newBlock = block.clone();
            newBlock.removeStatement(lastStatement);
            newBody = newBlock;
        } else {
            newBody = ctLoop.getFactory().createBlock();
        }
        boolean isUsedAfterLoop = SpoonUtil.getNextStatements((CtStatement)ctLoop).stream().anyMatch(statement -> UsesFinder.variableUses(ctLocalVariable).nestedIn((CtElement)statement).hasAny());
        List<Object> init = List.of(ctLocalVariable);
        if (isUsedAfterLoop) {
            init = List.of();
        }
        CtBinaryOperator condition = null;
        if (ctLoop instanceof CtWhile) {
            CtLiteral literal;
            CtWhile ctWhile = (CtWhile)ctLoop;
            CtExpression ctExpression = ctWhile.getLoopingExpression();
            if (!(ctExpression instanceof CtLiteral) || !((Boolean)(literal = (CtLiteral)ctExpression).getValue()).equals(true)) {
                condition = ctWhile.getLoopingExpression();
            }
        } else if (ctLoop instanceof CtForEach) {
            CtInvocation upperBound;
            CtForEach ctForEach = (CtForEach)ctLoop;
            if (UsesFinder.variableUses(ctForEach.getVariable()).nestedIn((CtElement)ctForEach.getBody()).hasAny()) {
                return null;
            }
            Factory factory = ctLoop.getFactory();
            if (ctForEach.getExpression().getType().isArray()) {
                CtFieldReference arrayLengthReference = factory.createFieldReference();
                arrayLengthReference.setDeclaringType(ctForEach.getExpression().getType().clone());
                arrayLengthReference.setSimpleName("length");
                CtFieldRead fieldRead = factory.createFieldRead();
                fieldRead.setTarget(ctForEach.getExpression().clone());
                fieldRead.setVariable((CtVariableReference)arrayLengthReference);
                upperBound = fieldRead;
            } else {
                List methods = ctForEach.getExpression().getType().getTypeDeclaration().getMethodsByName("size");
                if (methods.isEmpty()) {
                    return null;
                }
                upperBound = factory.createInvocation(ctForEach.getExpression().clone(), ((CtMethod)methods.get(0)).getReference(), List.of());
            }
            condition = SpoonUtil.createBinaryOperator(factory.createVariableRead((CtVariableReference)ctLocalVariable.getReference(), false), upperBound, BinaryOperatorKind.LT);
        } else {
            return null;
        }
        CtFor ctFor = LoopShouldBeFor.createCtFor(init, (CtExpression<Boolean>)condition, List.of(lastStatement), (CtStatement)newBody);
        if (isUsedAfterLoop) {
            return new LoopSuggestion((CtStatement)ctLocalVariable, ctFor);
        }
        return new LoopSuggestion(null, ctFor);
    }

    @Override
    protected void check(final StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtLoop>(){

            public void process(CtLoop ctLoop) {
                if (ctLoop.isImplicit() || !ctLoop.getPosition().isValidPosition() || ctLoop.getBody() == null) {
                    return;
                }
                LoopSuggestion forLoop = LoopShouldBeFor.getCounter(ctLoop, staticAnalysis.getCodeModel());
                if (forLoop != null) {
                    LoopShouldBeFor.this.addLocalProblem((CtElement)ctLoop, new LocalizedMessage("loop-should-be-for", Map.of("suggestion", forLoop.toString())), ProblemType.LOOP_SHOULD_BE_FOR);
                }
            }
        });
    }

    private record LoopSuggestion(CtStatement beforeLoop, CtFor ctFor) {
        @Override
        public String toString() {
            String result = "%n%s".formatted(this.ctFor);
            if (this.beforeLoop != null) {
                result = "%n%s%s".formatted(this.beforeLoop, result);
            }
            return result;
        }
    }
}

