/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayDeque;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.LOOP_SHOULD_BE_DO_WHILE})
public class LoopShouldBeDoWhile
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtWhile>(){

            public void process(CtWhile ctWhile) {
                if (ctWhile.isImplicit() || !ctWhile.getPosition().isValidPosition() || ctWhile.getBody() == null) {
                    return;
                }
                ArrayDeque<CtStatement> loopStatements = new ArrayDeque<CtStatement>(SpoonUtil.getEffectiveStatements(ctWhile.getBody()));
                CtStatement currentStatementBeforeLoop = SpoonUtil.getPreviousStatement((CtStatement)ctWhile).orElse(null);
                if (currentStatementBeforeLoop == null || loopStatements.isEmpty()) {
                    return;
                }
                while (!loopStatements.isEmpty() && currentStatementBeforeLoop != null) {
                    CtStatement lastStatement = (CtStatement)loopStatements.removeLast();
                    if (!lastStatement.equals(currentStatementBeforeLoop)) {
                        return;
                    }
                    currentStatementBeforeLoop = SpoonUtil.getPreviousStatement(currentStatementBeforeLoop).orElse(null);
                }
                if (loopStatements.isEmpty()) {
                    LoopShouldBeDoWhile.this.addLocalProblem((CtElement)ctWhile.getLoopingExpression(), new LocalizedMessage("loop-should-be-do-while", Map.of("suggestion", "%ndo %s while (%s)".formatted(SpoonUtil.truncatedSuggestion((CtElement)ctWhile.getBody()), ctWhile.getLoopingExpression()))), ProblemType.LOOP_SHOULD_BE_DO_WHILE);
                }
            }
        });
    }
}

