/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.CodePosition;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

@ExecutableCheck(reportedProblems={ProblemType.IMPORT_TYPES})
public class ImportTypes
extends IntegratedCheck {
    private static Optional<CtElement> findParentSourcePosition(CtElement ctElement) {
        CtElement currentElement = ctElement;
        while (currentElement.isParentInitialized() && !currentElement.getPosition().isValidPosition()) {
            try {
                currentElement = currentElement.getParent();
            }
            catch (ParentNotInitializedException e) {
                return Optional.empty();
            }
        }
        if (!currentElement.isParentInitialized() || !currentElement.getPosition().isValidPosition()) {
            return Optional.empty();
        }
        return Optional.of(currentElement);
    }

    private static boolean isSimplyQualified(CtTypeReference<?> ctTypeReference) {
        return ctTypeReference.isImplicit() || ctTypeReference.isSimplyQualified() || ctTypeReference.isPrimitive() || ctTypeReference instanceof CtTypeParameterReference;
    }

    private static List<CtTypeReference<?>> findQualifiedTypes(CtTypeReference<?> ctTypeReference) {
        if (ctTypeReference instanceof CtArrayTypeReference) {
            CtArrayTypeReference ctArrayTypeReference = (CtArrayTypeReference)ctTypeReference;
            return ImportTypes.findQualifiedTypes(ctArrayTypeReference.getArrayType());
        }
        CtTypeReference type = ctTypeReference;
        while (type.getDeclaringType() != null) {
            type = type.getDeclaringType();
        }
        ArrayList result = new ArrayList();
        if (!ImportTypes.isSimplyQualified(type) && !type.getParent().isImplicit()) {
            result.add(type);
        }
        for (CtTypeReference typeArgument : type.getActualTypeArguments()) {
            result.addAll(ImportTypes.findQualifiedTypes(typeArgument));
        }
        return result;
    }

    private void checkCtTypeReference(CtTypeReference<?> ctTypeReference) {
        CodePosition codePosition = CodePosition.fromSourcePosition(ImportTypes.findParentSourcePosition(ctTypeReference).orElseThrow().getPosition(), ctTypeReference, this.getRoot());
        for (CtTypeReference<?> typeReference : ImportTypes.findQualifiedTypes(ctTypeReference)) {
            this.addLocalProblem(codePosition, (Translatable)new LocalizedMessage("import-types", Map.of("type", typeReference.getQualifiedName())), ProblemType.IMPORT_TYPES);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public <T> void visitCtField(CtField<T> ctVariable) {
                if (!ctVariable.isImplicit()) {
                    ImportTypes.this.checkCtTypeReference(ctVariable.getType());
                }
                super.visitCtField(ctVariable);
            }

            public <T> void visitCtLocalVariable(CtLocalVariable<T> ctVariable) {
                if (!ctVariable.isImplicit() && !ctVariable.isInferred()) {
                    ImportTypes.this.checkCtTypeReference(ctVariable.getType());
                }
                super.visitCtLocalVariable(ctVariable);
            }

            public <T> void visitCtParameter(CtParameter<T> ctVariable) {
                if (!ctVariable.isImplicit()) {
                    ImportTypes.this.checkCtTypeReference(ctVariable.getType());
                }
                super.visitCtParameter(ctVariable);
            }
        });
    }
}

