/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.UsesFinder;
import java.util.Map;
import java.util.Optional;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtType;

@ExecutableCheck(reportedProblems={ProblemType.FIELD_SHOULD_BE_FINAL})
public class FieldShouldBeFinal
extends IntegratedCheck {
    private static <T> boolean canBeFinal(CtField<T> ctField) {
        boolean hasExplicitValue;
        CtClass ctClass;
        block13: {
            block12: {
                if (ctField.isFinal()) {
                    return true;
                }
                CtType ctType = ctField.getDeclaringType();
                if (!(ctType instanceof CtClass)) break block12;
                ctClass = (CtClass)ctType;
                if (!UsesFinder.variableWrites(ctField).hasAnyMatch(ctFieldWrite -> ctFieldWrite.getParent(CtConstructor.class) == null)) break block13;
            }
            return false;
        }
        if (ctField.isProtected() && SpoonUtil.hasSubtype(ctClass)) {
            return false;
        }
        boolean bl = hasExplicitValue = ctField.getDefaultExpression() != null && !ctField.getDefaultExpression().isImplicit();
        if (ctField.isStatic()) {
            return hasExplicitValue && !UsesFinder.variableWrites(ctField).hasAny();
        }
        int allowedWrites = 1;
        if (hasExplicitValue) {
            allowedWrites = 0;
        }
        for (CtConstructor ctConstructor : ctClass.getConstructors()) {
            if (ctConstructor.isImplicit() && allowedWrites != 0) {
                return false;
            }
            int mainPathWrites = 0;
            int otherPathWrites = 0;
            for (CtStatement ctStatement : SpoonUtil.getEffectiveStatementsOf((CtBodyHolder)ctConstructor)) {
                if (ctStatement instanceof CtAssignment) {
                    CtAssignment ctAssignment = (CtAssignment)ctStatement;
                    if (UsesFinder.variableWrites(ctField).nestedIn((CtElement)ctAssignment).hasAny()) {
                        ++mainPathWrites;
                        continue;
                    }
                }
                if (!UsesFinder.variableWrites(ctField).nestedIn((CtElement)ctStatement).hasAny()) continue;
                ++otherPathWrites;
            }
            if (mainPathWrites == allowedWrites && otherPathWrites == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtField<?>>(){

            public void process(CtField<?> ctField) {
                if (ctField.isImplicit() || !ctField.getPosition().isValidPosition() || ctField.isFinal()) {
                    return;
                }
                if (FieldShouldBeFinal.canBeFinal(ctField)) {
                    FieldShouldBeFinal.this.addLocalProblem(ctField, new LocalizedMessage("field-should-be-final", Map.of("name", ctField.getSimpleName())), ProblemType.FIELD_SHOULD_BE_FINAL);
                }
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(4);
    }
}

