/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;

@ExecutableCheck(reportedProblems={ProblemType.COMPARE_CHAR_VALUE})
public class CompareCharValue
extends IntegratedCheck {
    private static final int MIN_ASCII_VALUE = 1;
    private static final int MAX_ASCII_VALUE = 127;
    private static final Set<BinaryOperatorKind> COMPARISON_OPERATORS = EnumSet.of(BinaryOperatorKind.EQ, new BinaryOperatorKind[]{BinaryOperatorKind.NE, BinaryOperatorKind.GE, BinaryOperatorKind.GT, BinaryOperatorKind.LE, BinaryOperatorKind.LT});

    private static Optional<Integer> getComparedIntegerValue(CtExpression<?> left, CtExpression<?> right) {
        CtLiteral literal;
        Object object;
        if (!(SpoonUtil.isTypeEqualTo(left.getType(), Character.TYPE) && (object = SpoonUtil.resolveConstant(right)) instanceof CtLiteral && (object = (literal = (CtLiteral)object).getValue()) instanceof Integer)) {
            return Optional.empty();
        }
        Integer value = (Integer)object;
        if (value < 1 || value > 127) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtBinaryOperator<?>>(){

            public void process(CtBinaryOperator<?> ctBinaryOperator) {
                if (ctBinaryOperator.isImplicit() || !ctBinaryOperator.getPosition().isValidPosition() || !COMPARISON_OPERATORS.contains(ctBinaryOperator.getKind())) {
                    return;
                }
                CtExpression left = ctBinaryOperator.getLeftHandOperand();
                CtExpression right = ctBinaryOperator.getRightHandOperand();
                CtExpression charExpression = left;
                Optional<Integer> number = CompareCharValue.getComparedIntegerValue(left, right);
                if (number.isEmpty()) {
                    charExpression = right;
                    number = CompareCharValue.getComparedIntegerValue(right, left);
                }
                if (number.isEmpty()) {
                    return;
                }
                int asciiValue = number.get();
                CompareCharValue.this.addLocalProblem(ctBinaryOperator, new LocalizedMessage("compare-char-value", Map.of("expression", charExpression, "intValue", asciiValue, "charValue", "" + (char)asciiValue)), ProblemType.COMPARE_CHAR_VALUE);
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(3);
    }
}

