/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.UsesFinder;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;

@ExecutableCheck(reportedProblems={ProblemType.AVOID_RECOMPILING_REGEX})
public class AvoidRecompilingRegex
extends IntegratedCheck {
    private boolean isPatternInvocation(CtInvocation<?> ctInvocation) {
        CtTypeAccess ctTypeAccess;
        CtExpression ctExpression = ctInvocation.getTarget();
        return ctExpression instanceof CtTypeAccess && SpoonUtil.isTypeEqualTo((ctTypeAccess = (CtTypeAccess)ctExpression).getAccessedType(), Pattern.class) && List.of("matches", "compile").contains(ctInvocation.getExecutable().getSimpleName());
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtField<String>>(){

            public void process(CtField<String> ctField) {
                if (ctField.isImplicit() || !ctField.getPosition().isValidPosition() || !SpoonUtil.isTypeEqualTo(ctField.getType(), String.class) || ctField.getDefaultExpression() == null) {
                    return;
                }
                CtExpression ctExpression = SpoonUtil.resolveCtExpression(ctField.getDefaultExpression());
                if (!(ctExpression instanceof CtLiteral)) {
                    return;
                }
                boolean isPattern = UsesFinder.variableUses(ctField).hasAnyAndAllMatch(ctVariableAccess -> {
                    CtInvocation ctInvocation;
                    CtElement patt2211$temp = ctVariableAccess.getParent();
                    return patt2211$temp instanceof CtInvocation && AvoidRecompilingRegex.this.isPatternInvocation(ctInvocation = (CtInvocation)patt2211$temp);
                });
                if (isPattern) {
                    AvoidRecompilingRegex.this.addLocalProblem(ctField, new LocalizedMessage("avoid-recompiling-regex", Map.of("suggestion", "Pattern.compile(" + ctExpression + ")")), ProblemType.AVOID_RECOMPILING_REGEX);
                }
            }
        });
    }
}

