/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.exceptions;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Iterator;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtThrow;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;

@ExecutableCheck(reportedProblems={ProblemType.EXCEPTION_WITHOUT_MESSAGE})
public class ExceptionMessageCheck
extends IntegratedCheck {
    private static boolean isExceptionWithoutMessage(CtExpression<?> expression) {
        CtConstructor ctConstructor;
        CtConstructorCall ctConstructorCall;
        block5: {
            block4: {
                if (!(expression instanceof CtConstructorCall)) break block4;
                ctConstructorCall = (CtConstructorCall)expression;
                if (SpoonUtil.isSubtypeOf(expression.getType(), Exception.class)) break block5;
            }
            return false;
        }
        CtExecutable ctExecutable = ctConstructorCall.getExecutable().getExecutableDeclaration();
        if (ctExecutable instanceof CtConstructor && (ctConstructor = (CtConstructor)ctExecutable).getBody().filterChildren(ctElement -> {
            CtInvocation ctInvocation;
            return ctElement instanceof CtInvocation && (ctInvocation = (CtInvocation)ctElement).getExecutable().isConstructor() && ExceptionMessageCheck.hasMessage(ctInvocation.getArguments());
        }).first() != null) {
            return false;
        }
        return !ExceptionMessageCheck.hasMessage(ctConstructorCall.getArguments());
    }

    private static boolean hasMessage(Iterable<? extends CtExpression<?>> arguments) {
        Iterator<CtExpression<?>> iterator = arguments.iterator();
        if (iterator.hasNext()) {
            CtExpression<?> ctExpression = iterator.next();
            if (SpoonUtil.isSubtypeOf(ctExpression.getType(), Throwable.class)) {
                return true;
            }
            String literal = SpoonUtil.tryGetStringLiteral(ctExpression).orElse(null);
            return literal == null || !literal.isBlank();
        }
        return false;
    }

    private static boolean isInAllowedContext(CtElement ctElement) {
        CtConstructor ctConstructor = (CtConstructor)ctElement.getParent(CtConstructor.class);
        if (ctConstructor != null && ctConstructor.isPrivate()) {
            return true;
        }
        CtCase ctCase = (CtCase)ctElement.getParent(CtCase.class);
        return ctCase != null && ctCase.getCaseExpressions().isEmpty();
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtThrow>(){

            public void process(CtThrow throwStmt) {
                if (ExceptionMessageCheck.isExceptionWithoutMessage(throwStmt.getThrownExpression()) && !ExceptionMessageCheck.isInAllowedContext((CtElement)throwStmt)) {
                    ExceptionMessageCheck.this.addLocalProblem((CtElement)throwStmt, new LocalizedMessage("exception-message"), ProblemType.EXCEPTION_WITHOUT_MESSAGE);
                }
            }
        });
    }
}

