/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.exceptions;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Map;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

@ExecutableCheck(reportedProblems={ProblemType.EXCEPTION_CAUGHT_IN_SURROUNDING_BLOCK, ProblemType.EXCEPTION_SHOULD_NEVER_BE_CAUGHT})
public class ExceptionControlFlowCheck
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public void visitCtTry(CtTry ctTry) {
                final ArrayList thrownExceptions = new ArrayList();
                ctTry.getBody().accept((CtVisitor)new CtScanner(){

                    public void visitCtThrow(CtThrow throwStatement) {
                        thrownExceptions.add(throwStatement.getThrownExpression().getType());
                        super.visitCtThrow(throwStatement);
                    }
                });
                for (CtCatch catchBlock : ctTry.getCatchers()) {
                    CtTypeReference caughtException = catchBlock.getParameter().getType();
                    if (!thrownExceptions.stream().anyMatch(e -> e.getQualifiedName().equals(caughtException.getQualifiedName())) && !thrownExceptions.stream().anyMatch(e -> e.isSubtypeOf(caughtException))) continue;
                    ExceptionControlFlowCheck.this.addLocalProblem((CtElement)catchBlock.getParameter(), new LocalizedMessage("exception-controlflow-caught", Map.of("exception", caughtException.getSimpleName())), ProblemType.EXCEPTION_CAUGHT_IN_SURROUNDING_BLOCK);
                }
                super.visitCtTry(ctTry);
            }

            public void visitCtCatch(CtCatch ctCatch) {
                if (ctCatch.isImplicit() || !ctCatch.getPosition().isValidPosition()) {
                    super.visitCtCatch(ctCatch);
                    return;
                }
                for (CtTypeReference ctTypeReference : ctCatch.getParameter().getMultiTypes()) {
                    if (!SpoonUtil.isTypeEqualTo(ctTypeReference, NullPointerException.class, ArithmeticException.class, ArrayIndexOutOfBoundsException.class, ArrayStoreException.class, ClassCastException.class, IndexOutOfBoundsException.class, NegativeArraySizeException.class, StringIndexOutOfBoundsException.class) && !ctTypeReference.isSubtypeOf(ctCatch.getFactory().createCtTypeReference(Error.class))) continue;
                    ExceptionControlFlowCheck.this.addLocalProblem((CtElement)ctCatch.getParameter(), new LocalizedMessage("exception-controlflow-should-not-be-caught", Map.of("exception", ctTypeReference.getSimpleName())), ProblemType.EXCEPTION_SHOULD_NEVER_BE_CAUGHT);
                }
                super.visitCtCatch(ctCatch);
            }
        });
    }
}

