/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.debug;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtVariableRead;

@ExecutableCheck(reportedProblems={ProblemType.EXCEPTION_PRINT_STACK_TRACE})
public class PrintStackTraceCheck
extends IntegratedCheck {
    private static boolean hasInvokedPrintStackTrace(CtInvocation<?> ctInvocation) {
        CtVariableRead ctVariableRead;
        CtExpression ctExpression = ctInvocation.getTarget();
        return ctExpression instanceof CtVariableRead && (ctVariableRead = (CtVariableRead)ctExpression).getType().getTypeDeclaration() != null && SpoonUtil.isSubtypeOf(ctVariableRead.getType(), Throwable.class) && ctInvocation.getExecutable().getSimpleName().equals("printStackTrace");
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtInvocation<?>>(){

            public void process(CtInvocation<?> ctInvocation) {
                if (PrintStackTraceCheck.hasInvokedPrintStackTrace(ctInvocation)) {
                    PrintStackTraceCheck.this.addLocalProblem(ctInvocation, new LocalizedMessage("print-stack-trace"), ProblemType.EXCEPTION_PRINT_STACK_TRACE);
                }
            }
        });
    }
}

