/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.CodeModel;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.CtElementStream;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.UsesFinder;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.UNNECESSARY_BOXING})
public class UnnecessaryBoxing
extends IntegratedCheck {
    private static boolean isBoxedType(CtTypeReference<?> ctTypeReference) {
        return !ctTypeReference.equals((Object)ctTypeReference.unbox());
    }

    private static <T> boolean isLikelyNull(CtExpression<T> ctExpression) {
        return ctExpression == null || SpoonUtil.isNullLiteral(ctExpression) || UnnecessaryBoxing.isBoxedType(ctExpression.getType());
    }

    private <T> void checkVariable(CtVariable<T> ctVariable, CodeModel model) {
        boolean hasNullAssigned;
        if (ctVariable.isImplicit() || !ctVariable.getPosition().isValidPosition()) {
            return;
        }
        CtTypeReference ctTypeReference = ctVariable.getType();
        if (ctTypeReference == null || !UnnecessaryBoxing.isBoxedType(ctTypeReference)) {
            return;
        }
        boolean bl = hasNullAssigned = UnnecessaryBoxing.isLikelyNull(ctVariable.getDefaultExpression()) || ((CtElementStream)UsesFinder.variableUses(ctVariable).ofType(CtVariableWrite.class).filter(use -> {
            CtAssignment assignment;
            CtElement patt1945$temp = use.getParent();
            return patt1945$temp instanceof CtAssignment && (assignment = (CtAssignment)patt1945$temp).getAssignment() != null && UnnecessaryBoxing.isLikelyNull(assignment.getAssignment());
        })).hasAny();
        if (!hasNullAssigned) {
            this.addLocalProblem((CtElement)ctVariable, (Translatable)new LocalizedMessage("suggest-replacement", Map.of("original", ctTypeReference.getSimpleName(), "suggestion", ctTypeReference.unbox().getSimpleName())), ProblemType.UNNECESSARY_BOXING);
        }
    }

    @Override
    protected void check(final StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtVariable<?>>(){

            public void process(CtVariable<?> ctVariable) {
                UnnecessaryBoxing.this.checkVariable(ctVariable, staticAnalysis.getCodeModel());
            }
        });
    }
}

