/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtRecord;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.CtExtendedModifier;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_MODIFIER, ProblemType.REDUNDANT_MODIFIER_VISIBILITY_ENUM_CONSTRUCTOR})
public class RedundantModifier
extends IntegratedCheck {
    private static Collection<CtExtendedModifier> getOrderedExtendedModifiers(CtModifiable ctModifiable) {
        ArrayList<CtExtendedModifier> result = new ArrayList<CtExtendedModifier>(ctModifiable.getExtendedModifiers());
        result.sort(Comparator.comparing(CtExtendedModifier::getKind));
        return result;
    }

    private void reportIfHasModifier(CtModifiable ctModifiable, ModifierKind ... modifiers) {
        this.reportIfHasModifier(ctModifiable, ProblemType.REDUNDANT_MODIFIER, modifiers);
    }

    private void reportIfHasModifier(CtModifiable ctModifiable, ProblemType problemType, ModifierKind ... modifiers) {
        if (ctModifiable.isImplicit() || !ctModifiable.getPosition().isValidPosition()) {
            return;
        }
        HashSet<ModifierKind> expectedModifiers = new HashSet<ModifierKind>(Arrays.asList(modifiers));
        List<ModifierKind> presentModifiers = RedundantModifier.getOrderedExtendedModifiers(ctModifiable).stream().filter(ctExtendedModifier -> !ctExtendedModifier.isImplicit()).map(CtExtendedModifier::getKind).filter(expectedModifiers::contains).toList();
        if (presentModifiers.isEmpty()) {
            return;
        }
        this.addLocalProblem((CtElement)ctModifiable, (Translatable)new LocalizedMessage("redundant-modifier", Map.of("modifier", presentModifiers.stream().map(ModifierKind::toString).collect(Collectors.joining(", ")))), problemType);
    }

    private void checkCtInterface(CtInterface<?> ctInterface) {
        this.reportIfHasModifier((CtModifiable)ctInterface, ModifierKind.ABSTRACT);
        for (CtField ctField : ctInterface.getFields()) {
            this.reportIfHasModifier((CtModifiable)ctField, ModifierKind.PUBLIC, ModifierKind.STATIC, ModifierKind.FINAL);
        }
        for (CtMethod ctMethod : ctInterface.getMethods()) {
            this.reportIfHasModifier((CtModifiable)ctMethod, ModifierKind.PUBLIC, ModifierKind.ABSTRACT);
        }
        for (CtType ctType : ctInterface.getNestedTypes()) {
            this.reportIfHasModifier((CtModifiable)ctType, ModifierKind.PUBLIC, ModifierKind.STATIC);
        }
    }

    private void checkCtType(CtType<?> ctType) {
        if (ctType instanceof CtInterface) {
            CtInterface ctInterface = (CtInterface)ctType;
            this.checkCtInterface(ctInterface);
        }
        if ((ctType.getDeclaringType() == null || !ctType.getDeclaringType().isInterface()) && (ctType instanceof CtRecord || ctType.isEnum() || ctType.isInterface())) {
            this.reportIfHasModifier((CtModifiable)ctType, ModifierKind.STATIC);
        } else if (ctType.isClass() && ctType.getDeclaringType() != null && ctType.getDeclaringType().isEnum()) {
            this.reportIfHasModifier((CtModifiable)ctType, ModifierKind.STATIC);
        }
        if (ctType.isFinal()) {
            for (CtMethod ctMethod : ctType.getMethods()) {
                this.reportIfHasModifier((CtModifiable)ctMethod, ModifierKind.FINAL);
            }
        }
        if (ctType instanceof CtRecord) {
            CtRecord ctRecord = (CtRecord)ctType;
            this.reportIfHasModifier((CtModifiable)ctRecord, ModifierKind.FINAL);
        }
        if (ctType instanceof CtEnum) {
            CtEnum ctEnum = (CtEnum)ctType;
            for (CtConstructor ctConstructor : ctEnum.getConstructors()) {
                this.reportIfHasModifier((CtModifiable)ctConstructor, ProblemType.REDUNDANT_MODIFIER_VISIBILITY_ENUM_CONSTRUCTOR, ModifierKind.PRIVATE);
            }
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public <T> void visitCtClass(CtClass<T> ctType) {
                if (ctType.isImplicit() || !ctType.getPosition().isValidPosition()) {
                    super.visitCtClass(ctType);
                    return;
                }
                RedundantModifier.this.checkCtType((CtType<?>)ctType);
                super.visitCtClass(ctType);
            }

            public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctType) {
                if (ctType.isImplicit() || !ctType.getPosition().isValidPosition()) {
                    super.visitCtEnum(ctType);
                    return;
                }
                RedundantModifier.this.checkCtType((CtType<?>)ctType);
                super.visitCtEnum(ctType);
            }

            public <T> void visitCtInterface(CtInterface<T> ctInterface) {
                if (ctInterface.isImplicit() || !ctInterface.getPosition().isValidPosition()) {
                    super.visitCtInterface(ctInterface);
                    return;
                }
                RedundantModifier.this.checkCtType((CtType<?>)ctInterface);
                super.visitCtInterface(ctInterface);
            }

            public void visitCtRecord(CtRecord ctType) {
                if (ctType.isImplicit() || !ctType.getPosition().isValidPosition()) {
                    super.visitCtRecord(ctType);
                    return;
                }
                RedundantModifier.this.checkCtType((CtType<?>)ctType);
                super.visitCtRecord(ctType);
            }
        });
    }
}

