/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.effects.AssignmentEffect;
import de.firemage.autograder.core.integrated.effects.Effect;
import java.util.List;
import java.util.Map;
import java.util.Set;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_IF_FOR_BOOLEAN})
public class RedundantIfForBooleanCheck
extends IntegratedCheck {
    private static final Set<String> METHODS_TO_IGNORE = Set.of("equals", "hashCode");

    private String makeSuggestion(CtExpression<?> ctExpression, Effect thenEffect, Effect elseEffect) {
        if (thenEffect instanceof AssignmentEffect) {
            AssignmentEffect thenAssignment = (AssignmentEffect)thenEffect;
            if (elseEffect instanceof AssignmentEffect) {
                return "%s = %s".formatted(thenAssignment.target(), ctExpression);
            }
        }
        return "return %s".formatted(ctExpression);
    }

    private void checkIfElse(CtExpression<?> condition, CtStatement thenStmt, CtStatement elseStmt) {
        Effect thenEffect = SpoonUtil.tryMakeEffect(thenStmt).orElse(null);
        Effect elseEffect = SpoonUtil.tryMakeEffect(elseStmt).orElse(null);
        if (thenEffect == null || elseEffect == null || !thenEffect.isSameEffect(elseEffect) || !(thenStmt instanceof CtReturn) && !(thenStmt instanceof CtAssignment) || thenEffect.value().isEmpty() || elseEffect.value().isEmpty()) {
            return;
        }
        CtExpression<?> thenValue = thenEffect.value().get();
        CtExpression<?> elseValue = elseEffect.value().get();
        if (!SpoonUtil.isBoolean(thenValue) || !SpoonUtil.isBoolean(elseValue)) {
            return;
        }
        Boolean thenLiteral = SpoonUtil.tryGetBooleanLiteral(thenValue).orElse(null);
        Boolean elseLiteral = SpoonUtil.tryGetBooleanLiteral(elseValue).orElse(null);
        if (thenLiteral != null && thenLiteral.equals(elseLiteral)) {
            return;
        }
        CtBinaryOperator thenCondition = null;
        if (thenLiteral == null) {
            thenCondition = SpoonUtil.createBinaryOperator(condition, thenValue, BinaryOperatorKind.AND);
        } else if (thenLiteral.booleanValue()) {
            thenCondition = condition;
        }
        Object combinedCondition = thenCondition;
        if (elseLiteral == null) {
            combinedCondition = thenCondition == null ? SpoonUtil.createBinaryOperator(SpoonUtil.negate(condition), elseValue, BinaryOperatorKind.AND) : SpoonUtil.createBinaryOperator(combinedCondition, elseValue, BinaryOperatorKind.OR);
        } else if (elseLiteral.booleanValue()) {
            combinedCondition = thenCondition == null ? SpoonUtil.negate(condition) : SpoonUtil.createBinaryOperator(combinedCondition, SpoonUtil.negate(condition), BinaryOperatorKind.OR);
        }
        this.addLocalProblem((CtElement)condition, (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", this.makeSuggestion((CtExpression<?>)combinedCondition, thenEffect, elseEffect))), ProblemType.REDUNDANT_IF_FOR_BOOLEAN);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtBlock<?>>(){

            public void process(CtBlock<?> block) {
                CtMethod parentMethod = (CtMethod)block.getParent(CtMethod.class);
                if (parentMethod != null && METHODS_TO_IGNORE.contains(parentMethod.getSimpleName())) {
                    return;
                }
                List<CtStatement> statements = SpoonUtil.getEffectiveStatements(block);
                for (int i = 0; i < statements.size(); ++i) {
                    CtIf ifStmt;
                    CtStatement statement = statements.get(i);
                    if (!(statement instanceof CtIf) || (ifStmt = (CtIf)statement).getThenStatement() == null) continue;
                    CtStatement thenStatement = SpoonUtil.unwrapStatement(ifStmt.getThenStatement());
                    CtStatement elseStatement = ifStmt.getElseStatement();
                    if (elseStatement == null && i + 1 < statements.size()) {
                        elseStatement = statements.get(i + 1);
                    }
                    if (elseStatement == null) continue;
                    RedundantIfForBooleanCheck.this.checkIfElse(ifStmt.getCondition(), thenStatement, SpoonUtil.unwrapStatement(elseStatement));
                }
            }
        });
    }
}

