/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.effects.Effect;
import de.firemage.autograder.core.integrated.effects.TerminalEffect;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_ELSE})
public class RedundantElse
extends IntegratedCheck {
    private static final int MINIMUM_STATEMENTS = 5;

    private Optional<TerminalEffect> getTerminalEffect(CtStatement ctStatement) {
        List<CtStatement> ctStatements = SpoonUtil.getEffectiveStatements(ctStatement);
        if (ctStatements.isEmpty()) {
            return Optional.empty();
        }
        Optional<Effect> optionalEffect = SpoonUtil.tryMakeEffect(ctStatements.get(ctStatements.size() - 1));
        return optionalEffect.flatMap(effect -> {
            if (effect instanceof TerminalEffect) {
                TerminalEffect terminalEffect = (TerminalEffect)effect;
                return Optional.of(terminalEffect);
            }
            return Optional.empty();
        });
    }

    private void checkCtIf(CtIf ctIf) {
        CtStatement ctStatement;
        if (ctIf.getThenStatement() == null || ctIf.getElseStatement() == null) {
            return;
        }
        TerminalEffect effect = this.getTerminalEffect(ctIf.getThenStatement()).orElse(null);
        if (effect == null) {
            return;
        }
        String elseIf = "";
        List<CtStatement> elseStatements = SpoonUtil.getEffectiveStatements(ctIf.getElseStatement());
        int numberOfElseStatements = elseStatements.size();
        if (elseStatements.size() == 1 && (ctStatement = elseStatements.get(0)) instanceof CtIf) {
            CtIf ctElseIf = (CtIf)ctStatement;
            if (!ctIf.getElseStatement().isImplicit()) {
                return;
            }
            if (ctElseIf.getElseStatement() == null || ctElseIf.getElseStatement().isImplicit()) {
                return;
            }
            if (ctElseIf.getThenStatement() == null || this.getTerminalEffect(ctElseIf.getThenStatement()).isEmpty()) {
                return;
            }
            numberOfElseStatements = SpoonUtil.getEffectiveStatements(ctElseIf.getThenStatement()).size();
            elseIf = " else if (b) { ... }";
        } else if (ctIf.getElseStatement().isImplicit()) {
            return;
        }
        if (numberOfElseStatements <= 5) {
            return;
        }
        this.addLocalProblem((CtElement)ctIf.getCondition(), (Translatable)new LocalizedMessage("redundant-else", Map.of("expected", "if (a) { ... %s; }%s elseCode;".formatted(effect.ctStatement(), elseIf), "given", "if (a) { ... %s; }%s else { elseCode; }".formatted(effect.ctStatement(), elseIf))), ProblemType.REDUNDANT_ELSE);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtIf>(){

            public void process(CtIf ctIf) {
                List<CtStatement> ctStatements;
                if (ctIf.isImplicit() || !ctIf.getPosition().isValidPosition()) {
                    return;
                }
                CtIf parentIf = (CtIf)ctIf.getParent(CtIf.class);
                if (parentIf != null && parentIf.getElseStatement() != null && (ctStatements = SpoonUtil.getEffectiveStatements(parentIf.getElseStatement())).size() == 1 && ctStatements.get(0).equals(ctIf)) {
                    return;
                }
                RedundantElse.this.checkCtIf(ctIf);
            }
        });
    }
}

