/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtRecord;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_DEFAULT_CONSTRUCTOR})
public class RedundantConstructorCheck
extends IntegratedCheck {
    private static final Logger LOG = LoggerFactory.getLogger(RedundantConstructorCheck.class);
    private static final Translatable MESSAGE = new LocalizedMessage("implicit-constructor-exp");

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtClass<?>>(){

            public void process(CtClass<?> element) {
                CtConstructor redundantCtor = null;
                if (element instanceof CtRecord) {
                    CtRecord record = (CtRecord)element;
                    CtTypeReference[] types = (CtTypeReference[])record.getFields().stream().map(CtTypedElement::getType).toArray(CtTypeReference[]::new);
                    CtConstructor canonicalCtor = record.getConstructor(types);
                    if (canonicalCtor != null && !canonicalCtor.isImplicit() && RedundantConstructorCheck.this.hasEffectivelyDefaultVisibility((CtClass<?>)record, (CtConstructor<?>)canonicalCtor) && RedundantConstructorCheck.this.isDefaultBodyRecord(record, canonicalCtor)) {
                        redundantCtor = canonicalCtor;
                    }
                } else {
                    Set ctors = element.getConstructors();
                    if (ctors.size() != 1) {
                        return;
                    }
                    CtConstructor ctor = (CtConstructor)ctors.iterator().next();
                    if (!ctor.isImplicit() && ctor.getParameters().isEmpty() && RedundantConstructorCheck.this.hasEffectivelyDefaultVisibility(element, ctor) && RedundantConstructorCheck.this.isDefaultBody(ctor.getBody()) && ctor.getThrownTypes().isEmpty()) {
                        redundantCtor = ctor;
                    }
                }
                if (redundantCtor != null) {
                    RedundantConstructorCheck.this.addLocalProblem(redundantCtor, MESSAGE, ProblemType.REDUNDANT_DEFAULT_CONSTRUCTOR);
                }
            }
        });
    }

    private boolean hasEffectivelyDefaultVisibility(CtClass<?> type, CtConstructor<?> ctor) {
        if (type.isEnum() || type.isPrivate()) {
            return true;
        }
        if (type.isPublic()) {
            return ctor.isPublic();
        }
        if (type.isProtected()) {
            return ctor.isProtected();
        }
        return !ctor.isPrivate();
    }

    private boolean isDefaultBody(CtBlock<?> block) {
        return block.getStatements().stream().filter(Predicate.not(CtElement::isImplicit)).allMatch(statement -> {
            CtInvocation invocation;
            return statement instanceof CtInvocation && (invocation = (CtInvocation)statement).getExecutable().isConstructor() && invocation.getArguments().isEmpty() && invocation.getTarget() == null;
        });
    }

    private boolean isDefaultBodyRecord(CtRecord record, CtConstructor<?> ctor) {
        return ctor.getBody().getStatements().stream().filter(Predicate.not(CtElement::isImplicit)).allMatch(statement -> {
            if (!(statement instanceof CtAssignment)) {
                return false;
            }
            CtAssignment assignment = (CtAssignment)statement;
            CtExpression patt5529$temp = assignment.getAssigned();
            if (!(patt5529$temp instanceof CtFieldWrite)) {
                return false;
            }
            CtFieldWrite fieldWrite = (CtFieldWrite)patt5529$temp;
            CtExpression patt5632$temp = assignment.getAssignment();
            if (!(patt5632$temp instanceof CtVariableRead)) {
                return false;
            }
            CtVariableRead variableRead = (CtVariableRead)patt5632$temp;
            CtVariableReference patt5739$temp = variableRead.getVariable();
            if (!(patt5739$temp instanceof CtParameterReference)) {
                return false;
            }
            CtParameterReference parameter = (CtParameterReference)patt5739$temp;
            int index = ctor.getParameters().indexOf(parameter.getDeclaration());
            if (index < 0) {
                LOG.error("encountered CtParameter not present in constructor parameters");
                return false;
            }
            return record.getFields().get(index) == fieldWrite.getVariable().getDeclaration();
        });
    }
}

