/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import java.util.Set;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_BOOLEAN_EQUAL})
public class RedundantBooleanEqual
extends IntegratedCheck {
    private static final Set<BinaryOperatorKind> OPERATORS = Set.of(BinaryOperatorKind.EQ, BinaryOperatorKind.NE);

    private void reportProblem(CtBinaryOperator<?> ctBinaryOperator, boolean literal, CtExpression<?> otherSide) {
        boolean realLiteral = literal;
        if (ctBinaryOperator.getKind() == BinaryOperatorKind.NE) {
            realLiteral = !literal;
        }
        CtExpression<?> suggestion = otherSide;
        if (!realLiteral) {
            suggestion = SpoonUtil.negate(otherSide);
        }
        this.addLocalProblem((CtElement)ctBinaryOperator, (Translatable)new LocalizedMessage("redundant-boolean-equal", Map.of("suggestion", suggestion)), ProblemType.REDUNDANT_BOOLEAN_EQUAL);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtBinaryOperator<Boolean>>(){

            public void process(CtBinaryOperator<Boolean> ctBinaryOperator) {
                if (!(!ctBinaryOperator.isImplicit() && ctBinaryOperator.getPosition().isValidPosition() && OPERATORS.contains(ctBinaryOperator.getKind()) && SpoonUtil.isBoolean(ctBinaryOperator.getLeftHandOperand()) && SpoonUtil.isBoolean(ctBinaryOperator.getRightHandOperand()))) {
                    return;
                }
                CtExpression left = ctBinaryOperator.getLeftHandOperand();
                CtExpression right = ctBinaryOperator.getRightHandOperand();
                SpoonUtil.tryGetBooleanLiteral(left).ifPresentOrElse(literal -> RedundantBooleanEqual.this.reportProblem(ctBinaryOperator, (boolean)literal, (CtExpression<?>)right), () -> SpoonUtil.tryGetBooleanLiteral(right).ifPresent(literal -> RedundantBooleanEqual.this.reportProblem(ctBinaryOperator, (boolean)literal, (CtExpression<?>)left)));
            }
        });
    }
}

