/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

@ExecutableCheck(reportedProblems={ProblemType.FOR_WITH_MULTIPLE_VARIABLES, ProblemType.MULTIPLE_INLINE_STATEMENTS})
public class MultipleInlineStatements
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        final HashSet alreadyReported = new HashSet();
        staticAnalysis.processWith(new AbstractProcessor<CtStatement>(){

            public void process(CtStatement ctStatement) {
                CtAssignment ctAssignment;
                CtLocalVariable ctLocalVariable;
                CtFor ctFor;
                if (ctStatement instanceof CtFor && (ctFor = (CtFor)ctStatement).getForInit().size() > 1) {
                    MultipleInlineStatements.this.addLocalProblem((CtElement)ctFor.getForInit().get(0), new LocalizedMessage("for-loop-var"), ProblemType.FOR_WITH_MULTIPLE_VARIABLES);
                }
                if (ctStatement instanceof CtLocalVariable && !alreadyReported.contains(ctLocalVariable = (CtLocalVariable)ctStatement) && !(ctLocalVariable.getParent() instanceof CtFor)) {
                    LinkedHashSet<CtLocalVariable> others = new LinkedHashSet<CtLocalVariable>();
                    List variables = ctLocalVariable.getParent().getElements((Filter)new TypeFilter(CtLocalVariable.class));
                    for (CtLocalVariable ctVariable : variables) {
                        if (ctLocalVariable.equals(ctVariable) || ctVariable.isImplicit() || !ctVariable.getPosition().isValidPosition() || ctLocalVariable.getPosition().getLine() != ctVariable.getPosition().getLine()) continue;
                        others.add(ctVariable);
                    }
                    if (!others.isEmpty()) {
                        alreadyReported.add(ctLocalVariable);
                        alreadyReported.addAll(others);
                        MultipleInlineStatements.this.addLocalProblem((CtElement)ctLocalVariable, new LocalizedMessage("multiple-inline-statements"), ProblemType.MULTIPLE_INLINE_STATEMENTS);
                    }
                }
                if (ctStatement instanceof CtAssignment && (ctAssignment = (CtAssignment)ctStatement).getParent(CtAssignment.class) == null && ctAssignment.getAssignment() instanceof CtAssignment) {
                    MultipleInlineStatements.this.addLocalProblem((CtElement)ctAssignment, new LocalizedMessage("multiple-inline-statements"), ProblemType.MULTIPLE_INLINE_STATEMENTS);
                }
            }
        });
    }
}

